/*
* Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:   
* This file was autogenerated by rpcgen, but should be modified by the developer.
* Make sure you don't use the -component_mod flag in future or this file will be overwritten.
* Tue Oct 28 10:15:13 2003
* System Includes
*
*/




#include <stdio.h>
#include <errno.h>


/****************************************************************************************
 * 
 * Local Includes
 * 
 ***************************************************************************************/
#include "CSvcHostexecute.h"
#include "hostexecute.h"
#include "../ProcessLibrary/proclib.h"
#include "../include/standard_service_manager.h"
#include "../include/strncpynt.h"


/****************************************************************************************
 * 
 * File-scope variables
 * 
 ***************************************************************************************/
static CComponentManager<CSHostexecute> *iComponentManager;


/****************************************************************************************
 * 
 * Implementation
 * 
 ***************************************************************************************/


/****************************************************************************************
 * 
 * PUBLIC: GetInstanceKeyFromArgs
 * 
 ***************************************************************************************/
int CSvcHostexecute::GetInstanceKeyFromArgs( int aMethod, void *aArgs )
{
	// this method should never be called
	assert( !"NOT IMPLEMENTED" );
	return ERR_NONE;
}


/****************************************************************************************
 * 
 * PUBLIC: SetError
 * 
 ***************************************************************************************/
int CSvcHostexecute::SetError( int aMethod, void *aArgs, int aError )
{
	int rv = ERR_NONE;
	TExecuteResult *rv_execute_result;
	TComponentList *rv_component_list;

	switch( aMethod ) {

	// TComponentList
	case LIST_DEVICES:
		SET_LIST_ERROR_CODE( TComponentList, rv_component_list );
		break;

	// TExecuteResult
	case ST_EXECUTECOMMAND:
		rv_execute_result = (TExecuteResult*)aArgs;
		if( (rv_execute_result->iStandardOut).TVarData_val != NULL ) {
			free( (rv_execute_result->iStandardOut).TVarData_val );
			(rv_execute_result->iStandardOut).TVarData_val = NULL;
			(rv_execute_result->iStandardOut).TVarData_len = 0;
		}
		if( (rv_execute_result->iStandardError).TVarData_val != NULL ) {
			free( (rv_execute_result->iStandardError).TVarData_val );
			(rv_execute_result->iStandardError).TVarData_val = NULL;
			(rv_execute_result->iStandardError).TVarData_len = 0;
		}
		memset( rv_execute_result, 0, sizeof(TExecuteResult) );
		rv_execute_result->iResult = aError;
		break;

	// Error
	default:
		rv = ERR_INVALID_METHOD;
		break;
	}
	return rv;
}


/****************************************************************************************
 * 
 * PUBLIC: GetError
 * 
 ***************************************************************************************/
int CSvcHostexecute::GetError( int aMethod, void *aArgs )
{
	// this method should never be called
	assert( !"NOT IMPLEMENTED" );
	return ERR_NONE;
}


/****************************************************************************************
 * 
 * PUBLIC: StartRPCService
 * 
 ***************************************************************************************/
int CSvcHostexecute::StartRPCService( CComponentManager<CSHostexecute> *aComponentManager, TStartupInfo *aArg )
{
	assert( iComponentManager == NULL );
	iComponentManager = aComponentManager;
	return ERR_NONE;
}


/****************************************************************************************
 * 
 * PUBLIC: StopRPCService
 * 
 ***************************************************************************************/
int CSvcHostexecute::StopRPCService()
{
	iComponentManager = NULL;
	return ERR_NONE;
}


/****************************************************************************************
 * 
 * PUBLIC: st_executecommand
 * 
 ***************************************************************************************/
TExecuteResult CSvcHostexecute::st_executecommand( TExecuteRequest aArgs )
{
	TExecuteResult rv;
	int errcode;
	CAProcess process;
	TCAProcessError perr;
	TProcessExitReason preason;
	string *standardout = NULL, *standarderror = NULL;

	// init the rv
	memset( &rv, 0, sizeof(rv) );
	rv.iResult = ERR_NONE;

	// get the buffers
	if( aArgs.iRecordStandardOut != 0 ) {
		standardout = new string();
		assert( standardout != NULL );
	} 
	if( aArgs.iRecordStandartError != 0 ) {
		standarderror = new string();
		assert( standarderror != NULL );
	}

	// execute the process - return any errors
	perr = process.Execute( aArgs.iCommandLine, &errcode, aArgs.iTimeout, standardout, standarderror );
	if( perr != CAE_NONE ) {
		rv.iResult = ERR_EXECUTE_PROCESS_ERROR;
		rv.iErrorCode = (int)perr;
		rv.iErrorDetail = errno;
	}

	// save any output
	if( (standardout != NULL) && (standardout->length() > 0) ) {
		rv.iStandardOut.TVarData_val = (char*)malloc( standardout->length() + 1 );
		rv.iStandardOut.TVarData_len = standardout->length() + 1;
		STRNCPY_NULL_TERMINATE( rv.iStandardOut.TVarData_val, standardout->c_str(), standardout->length() + 1 );
	}
	if( (standarderror != NULL) && (standarderror->length() > 0) ) {
		rv.iStandardError.TVarData_val = (char*)malloc( standarderror->length() + 1 );
		rv.iStandardError.TVarData_len = standarderror->length() + 1;
		STRNCPY_NULL_TERMINATE( rv.iStandardError.TVarData_val, standarderror->c_str(), standarderror->length() + 1 );
	}

	// if there was an error then return now
	if( rv.iResult != ERR_NONE ) {
		return rv;
	}

	// save the status, exitreason, etc
	perr = process.GetExitReason( &preason );
	assert( perr == CAE_NONE );
	rv.iProcessExitReason = (int)preason;
	perr = process.GetExitCode( &errcode );
	assert( perr == CAE_NONE );
	rv.iProcessExitDetail = errcode;
	return rv;
}
