#!/bin/sh

####################################################################################################################
#
# Global Variables
#
####################################################################################################################
last_path="";


####################################################################################################################
#
# GetPath
# 
# $1 - Name of thing to get the path of
# $2 - Default path
#
# Places pathname in last_path global var
#
####################################################################################################################
GetPath()
{
    # Ask for the path
    echo -n "Enter the path for" $1 "["$2"]: ";
    read answer rubbish;

    # If the string is empty then replace with the default path
    if test -z $answer; then
	last_path=$2;
    else
	last_path=$answer;
    fi

    # Done
}


####################################################################################################################
#
# Ask
#
# $1 = Question string.
#
# Returns 1 for yes 0 for no
#
####################################################################################################################
Ask()
{
    echo -n $1 "[yes / no] ";
    read answer rubbish;
    if [ $answer = "yes" ]; then
	return 1;
    else
	return 0;
    fi
}



####################################################################################################################
#
# MAIN():
#
####################################################################################################################


####################################################################################################################
#
# (1) Print info
#
####################################################################################################################
clear
echo --------------------------------------------------------------------------------------------------------------
echo
echo "    Emulation Environment setup for the Network Emulator       "
echo
echo --------------------------------------------------------------------------------------------------------------


####################################################################################################################
#
# (2) Get path information
#
####################################################################################################################
GetPath "pppd" "/usr/sbin/pppd"
pppd_path=$last_path;
GetPath "the dynamics agents" "/home/penuser/dynamics/sbin/"
dynamics_sbin_path=$last_path;
echo --------------------------------------------------------------------------------------------------------------


####################################################################################################################
#
# (3) Setup the symlinks
#
####################################################################################################################
ln -v -f -s $pppd_path ../bin/pppd

ln -v -f -s $dynamics_sbin_path/dynmn_tool ../bin/dynmn_tool
ln -v -f -s $dynamics_sbin_path/dynfa_tool ../bin/dynfa_tool
ln -v -f -s $dynamics_sbin_path/dynha_tool ../bin/dynha_tool

ln -v -f -s $dynamics_sbin_path/dynmnd ../bin/dynmnd
ln -v -f -s $dynamics_sbin_path/dynfad ../bin/dynfad
ln -v -f -s $dynamics_sbin_path/dynhad ../bin/dynhad

ln -v -f -s ../ConfigurationFiles/dynmnd.ref_template.conf ../bin/dynmnd.template.conf
ln -v -f -s ../ConfigurationFiles/dynhad.ref_template.conf ../bin/dynhad.template.conf
ln -v -f -s ../ConfigurationFiles/dynfad.ref_template.conf ../bin/dynfad.template.conf

ln -v -f -s $dynamics_sbin_path/../etc/dynfad.key ../bin/dynfad.key

echo --------------------------------------------------------------------------------------------------------------


####################################################################################################################
#
# Done
#
####################################################################################################################
echo "    Setup successful"
echo --------------------------------------------------------------------------------------------------------------
