/*
* Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:    
* This file was autogenerated by rpcgen, but should be modified by the developer.
* Make sure you don't use the -component_mod flag in future or this file will be overwritten.
* Mon Oct 06 12:02:04 2003
* System Includes
*
*/





#include <stdio.h>


/****************************************************************************************
 * 
 * Local Includes
 * 
 ***************************************************************************************/
#include "CSvcFacontroller.h"
#include "facontroller.h"
#include "standard_service_manager.h"


/****************************************************************************************
 * 
 * File-scope variables
 * 
 ***************************************************************************************/
static TStartupInfo iStartupInfo;
static CIntegerAllocator *iIntegerAllocator;
static CComponentManager<CSFacontroller> *iComponentManager;


/****************************************************************************************
 * 
 * Implementation
 * 
 ***************************************************************************************/


/****************************************************************************************
 * 
 * PUBLIC: GetInstanceKeyFromArgs
 * 
 ***************************************************************************************/
int CSvcFacontroller::GetInstanceKeyFromArgs( int aMethod, void *aArgs )
{
	int rv;
	int *integer_ik;
	TFaTunnelID *tunnel_ik;
	TOptionDesc *option_ik;
	TTimeoutRequest *timeout_ik;
	TStartAgentRequest *startup_ik;
	TGetTunnelRequest *get_tunnel_req_ik;

	switch( aMethod ) {

	// Methods with a single integer argument that is the key
	case DSTR_REMOVEAGENT:
	case STOPMOBILEAGENT:
	case GETMOBILEAGENTSTATUS:
	case GETSTATUS:
	case LISTTUNNELS:
		integer_ik = (int*)aArgs;
		rv = *integer_ik;
		break;

	// Methods with TOptionDesc 
	case SETSINGLEOPTION:
	case REMOVESINGLEOPTION:
	case ADDLISTOPTION:
	case REMOVELISTOPTION:
		option_ik = (TOptionDesc*)aArgs;
		rv = option_ik->iAgentID;
		break;

	// TStartAgentRequest
	case STARTMOBILEAGENT:
	  startup_ik = (TStartAgentRequest*)aArgs;
	  rv = startup_ik->iAgentID;
	  break;

	// Tunnel ID
	case DESTROYTUNNELID:
		tunnel_ik = (TFaTunnelID*)aArgs;
		rv = tunnel_ik->iAgentID;
		break;

	// Timeout
	case SETTIMEOUT:
		timeout_ik = (TTimeoutRequest*)aArgs;
		rv = timeout_ik->iAgentID;
		break;

	// TGetTunnelRequest
	case GETTUNNELINFO:
		get_tunnel_req_ik = (TGetTunnelRequest*)aArgs;
		rv = get_tunnel_req_ik->iAgentID;
		break;
		
	// error
	default:
		rv = ERR_INVALID_METHOD;
		break;
	}
	return rv;
}


/****************************************************************************************
 * 
 * PUBLIC: SetError
 * 
 ***************************************************************************************/
int CSvcFacontroller::SetError( int aMethod, void *aArgs, int aError )
{
	int rv = ERR_NONE;
	TResult *result_rv;
	TComponentList *result_cl;
	TFaStatusInfo *result_fs;
	TFaTunnelList *result_tl;
	TFaTunnelInfo *result_ti;

	switch( aMethod ) {

	// TResult
	case CSTR_CREATEAGENT:
	case STARTMOBILEAGENT:
	case STOPMOBILEAGENT:
	case SETSINGLEOPTION:
	case REMOVESINGLEOPTION:
	case ADDLISTOPTION:
	case REMOVELISTOPTION:
	case DESTROYTUNNELID:
		SET_ERROR_CODE( TResult, iServiceResult, result_rv );
		break;

	// TComponent
	case LIST_DEVICES:
		SET_LIST_ERROR_CODE( TComponentList, result_cl );
		break;

	// TFaStatusInfo
	case GETSTATUS:
		SET_ERROR_CODE( TFaStatusInfo, iCallResult.iServiceResult, result_fs );
		break;

	// TFaTunnelList
	case LISTTUNNELS:
		SET_LIST_ERROR_CODE( TFaTunnelList, result_tl );
		break;

	// TFaTunnelInfo 
	case GETTUNNELINFO:
		SET_ERROR_CODE( TFaTunnelInfo, iCallResult.iServiceResult, result_ti );
		break;

	// error
	default:
		rv = ERR_INVALID_METHOD;
		break;
	}

	// done
	return rv;
}


/****************************************************************************************
 * 
 * PUBLIC: GetError - Currently this methods will only ever be caleld for CSTR_CREATEAGENT
 * 
 ***************************************************************************************/
int CSvcFacontroller::GetError( int aMethod, void *aArgs )
{
	TResult *result;

	// check assumption
	assert( aMethod == CSTR_CREATEAGENT );

	// return error code
	result = (TResult*)aArgs;
	return result->iServiceResult;
}


/****************************************************************************************
 * 
 * PUBLIC: StartRPCService
 * 
 ***************************************************************************************/
int CSvcFacontroller::StartRPCService( CComponentManager<CSFacontroller> *aComponentManager, void *aArg )
{
  int err;

  // save the passed args
  iStartupInfo = *((TStartupInfo*)aArg);
  
  // create the component manager
  assert( iComponentManager == NULL );
  iComponentManager = aComponentManager;
  
  // setup the integer allocator
  iIntegerAllocator = new CIntegerAllocator();
  assert( iIntegerAllocator != NULL );
  err = iIntegerAllocator->AddToIntegerPool( iStartupInfo.iStartHostAddressRange, iStartupInfo.iStopHostAddressRange );
  if( err == -1 ) {
    delete iIntegerAllocator;
    iIntegerAllocator = NULL;
    return ERR_INTEGER_ALLOCATOR_SETUP_ERROR;
  }
  return ERR_NONE;
}


/****************************************************************************************
 * 
 * PUBLIC: StopRPCService
 * 
 ***************************************************************************************/
int CSvcFacontroller::StopRPCService()
{
  // cleanup the integer allocator
  delete iIntegerAllocator;
  iIntegerAllocator = NULL;

  // cleanup the component manager (stubs do the deletion)
  iComponentManager = NULL;
  return ERR_NONE;
}


/****************************************************************************************
 * 
 * PUBLIC: GetStartupInfo
 * 
 ***************************************************************************************/
TStartupInfo CSvcFacontroller::GetStartupInfo()
{
	return iStartupInfo;
}


/****************************************************************************************
 * 
 * PUBLIC: GetIntegerAllocator
 * 
 ***************************************************************************************/
CIntegerAllocator *CSvcFacontroller::GetIntegerAllocator()
{
  return iIntegerAllocator;
}
