/*
* Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/


#if !defined(__KEYCODES_H__)
#define __KEYCODES_H__

#include <e32keys.h>

#define NO_MORE_KEYS	_S("NO_MORE_KEYS")	// end of array
#define NO_MORE_SCANCODEKEYS _S("NO_MORE_SCANCODE_KEYS")

//------------------------------------------------------------------------------
//This section represents the textual KEY codes entered by the end user

const TText* const ENUM_TEXTKEYArray[] = 
{
	_S("Null"),
	_S("Bell"),
	_S("Backspace"),
	_S("Tab"),
	_S("LineFeed"),
	_S("VerticalTab"),
	_S("FormFeed"),
	_S("Enter"),
	_S("Escape"),
	_S("Space"),
	_S("Delete"),
	_S("PrintScreen"),
	_S("Pause"),
	_S("Home"),
	_S("End"),
	_S("PageUp"),
	_S("PageDown"),
	_S("Insert"),
	_S("LeftArrow"),
	_S("RightArrow"),
	_S("UpArrow"),
	_S("DownArrow"),
	_S("LeftShift"),
	_S("RightShift"),
	_S("LeftAlt"),
	_S("RightAlt"),
	_S("LeftCtrl"),
	_S("RightCtrl"),
	_S("LeftFunc"),
	_S("RightFunc"),
	_S("CapsLock"),
	_S("NumLock"),
	_S("ScrollLock"),
	_S("F1"),
	_S("F2"),
	_S("F3"),
	_S("F4"),
	_S("F5"),
	_S("F6"),
	_S("F7"),
	_S("F8"),
	_S("F9"),
	_S("F10"),
	_S("F11"),
	_S("F12"),
	_S("F13"),
	_S("F14"),
	_S("F15"),
	_S("F16"),
	_S("F17"),
	_S("F18"),
	_S("F19"),
	_S("F20"),
	_S("F21"),
	_S("F22"),
	_S("F23"),
	_S("F24"),
    _S("Off"),
    _S("IncContrast"),
    _S("DecContrast"),
    _S("BacklightOn"),
    _S("BacklightOff"),
    _S("BacklightToggle"),
    _S("SliderDown"),
    _S("SliderUp"),
    _S("Menu"),
    _S("DictaphonePlay"),
    _S("DictaphoneStop"),
    _S("DictaphoneRecord"),
    _S("Help"),
    _S("Dial"),
	_S("ScreenDimension0"),
	_S("ScreenDimension1"),
	_S("ScreenDimension2"),
	_S("ScreenDimension3"),
	_S("IncVolume"),
	_S("DecVolume"),
	_S("Device0"),
	_S("Device1"),
	_S("Device2"),
	_S("Device3"),
	_S("Device4"),
	_S("Device5"),
	_S("Device6"),
	_S("Device7"),
	_S("Device8"),
	_S("Device9"),
	_S("DeviceA"),
	_S("DeviceB"),
	_S("DeviceC"),
	_S("DeviceD"),
	_S("DeviceE"),
	_S("DeviceF"),
	_S("Application0"),
	_S("Application1"),
	_S("Application2"),
	_S("Application3"),
	_S("Application4"),
	_S("Application5"),
	_S("Application6"),
	_S("Application7"),
	_S("Application8"),
	_S("Application9"),
	_S("ApplicationA"),
	_S("ApplicationB"),
	_S("ApplicationC"),
	_S("ApplicationD"),
	_S("ApplicationE"),
	_S("ApplicationF"),
	_S("Yes"),
	_S("No"),
	_S("IncBrightness"),
	_S("DecBrightness"),
	NO_MORE_KEYS
};

//------------------------------------------------------------------------------
//This section represents the TKeyCode values of the KEYS used by the end user

const TKeyCode ENUM_VALKEYArray[] =
{
	EKeyNull,
	EKeyBell,
	EKeyBackspace,
	EKeyTab,
	EKeyLineFeed,
	EKeyVerticalTab,
	EKeyFormFeed,
	EKeyEnter,
	EKeyEscape,
	EKeySpace,
	EKeyDelete,
	EKeyPrintScreen,
	EKeyPause,
	EKeyHome,
	EKeyEnd,
	EKeyPageUp,
	EKeyPageDown,
	EKeyInsert,
	EKeyLeftArrow,
	EKeyRightArrow,
	EKeyUpArrow,
	EKeyDownArrow,
	EKeyLeftShift,
	EKeyRightShift,
	EKeyLeftAlt,
	EKeyRightAlt,
	EKeyLeftCtrl,
	EKeyRightCtrl,
	EKeyLeftFunc,
	EKeyRightFunc,
	EKeyCapsLock,
	EKeyNumLock,
	EKeyScrollLock,
	EKeyF1,
	EKeyF2,
	EKeyF3,
	EKeyF4,
	EKeyF5,
	EKeyF6,
	EKeyF7,
	EKeyF8,
	EKeyF9,
	EKeyF10,
	EKeyF11,
	EKeyF12,
	EKeyF13,
	EKeyF14,
	EKeyF15,
	EKeyF16,
	EKeyF17,
	EKeyF18,
	EKeyF19,
	EKeyF20,
	EKeyF21,
	EKeyF22,
	EKeyF23,
	EKeyF24,
    EKeyOff,
    EKeyIncContrast,
    EKeyDecContrast,
    EKeyBacklightOn,
    EKeyBacklightOff,
    EKeyBacklightToggle,
    EKeySliderDown,
    EKeySliderUp,
    EKeyMenu,
    EKeyDictaphonePlay,
    EKeyDictaphoneStop,
    EKeyDictaphoneRecord,
    EKeyHelp,
    EKeyDial,
	EKeyScreenDimension0,
	EKeyScreenDimension1,
	EKeyScreenDimension2,
	EKeyScreenDimension3,
	EKeyIncVolume,
	EKeyDecVolume,
	EKeyDevice0,
	EKeyDevice1,
	EKeyDevice2,
	EKeyDevice3,
	EKeyDevice4,
	EKeyDevice5,
	EKeyDevice6,
	EKeyDevice7,
	EKeyDevice8,
	EKeyDevice9,
	EKeyDeviceA,
	EKeyDeviceB,
	EKeyDeviceC,
	EKeyDeviceD,
	EKeyDeviceE,
	EKeyDeviceF,
	EKeyApplication0,
	EKeyApplication1,
	EKeyApplication2,
	EKeyApplication3,
	EKeyApplication4,
	EKeyApplication5,
	EKeyApplication6,
	EKeyApplication7,
	EKeyApplication8,
	EKeyApplication9,
	EKeyApplicationA,
	EKeyApplicationB,
	EKeyApplicationC,
	EKeyApplicationD,
	EKeyApplicationE,
	EKeyApplicationF,
	EKeyYes,
	EKeyNo,
	EKeyIncBrightness,
	EKeyDecBrightness
};

//------------------------------------------------------------------------------
//This section represents the textual SCAN codes entered by the end user in sending system keypresses (L)

const TText* const ENUM_TEXTSCANCODEArray[] = 
{
	_S("Null"),
	_S("Backspace"),
	_S("Tab"),
	_S("Enter"),
	_S("Escape"),
	_S("Space"),
	_S("PrintScreen"),
	_S("Pause"),
	_S("Home"),
	_S("End"),
	_S("PageUp"),
	_S("PageDown"),
	_S("Insert"),
	_S("Delete"),
	_S("LeftArrow"),
	_S("RightArrow"),
	_S("UpArrow"),
	_S("DownArrow"),
	_S("LeftShift"),
	_S("RightShift"),
	_S("LeftAlt"),
	_S("RightAlt"),
	_S("LeftCtrl"),
	_S("RightCtrl"),
	_S("LeftFunc"),
	_S("RightFunc"),
	_S("CapsLock"),
	_S("NumLock"),
	_S("ScrollLock"),
	_S("F1"),
	_S("F2"),
	_S("F3"),
	_S("F4"),
	_S("F5"),
	_S("F6"),
	_S("F7"),
	_S("F8"),
	_S("F9"),
	_S("F10"),
	_S("F11"),
	_S("F12"),
	_S("F13"),
	_S("F14"),
	_S("F15"),
	_S("F16"),
	_S("F17"),
	_S("F18"),
	_S("F19"),
	_S("F20"),
	_S("F21"),
	_S("F22"),
	_S("F23"),
	_S("F24"),
	_S("XXX"),
	_S("Comma"),
	_S("FullStop"),
	_S("ForwardSlash"),
	_S("BackSlash"),
	_S("SemiColon"),
	_S("SingleQuote"),
	_S("Hash"),
	_S("SquareBracketLeft"),
	_S("SquareBracketRight"),
	_S("Minus"),
	_S("Equals"),
	_S("NkpForwardSlash"),
	_S("NkpAsterisk"),
	_S("NkpMinus"),
	_S("NkpPlus"),
	_S("NkpEnter"),
	_S("Nkp1"),
	_S("Nkp2"),
	_S("Nkp3"),
	_S("Nkp4"),
	_S("Nkp5"),
	_S("Nkp6"),
	_S("Nkp7"),
	_S("Nkp8"),
	_S("Nkp9"),
	_S("Nkp0"),
	_S("NkpFullStop"),
    _S("Menu"),
    _S("BacklightOn"),
    _S("BacklightOff"),
    _S("BacklightToggle"),
    _S("IncContrast"),
    _S("DecContrast"),
    _S("SliderDown"),
    _S("SliderUp"),
    _S("DictaphonePlay"),
    _S("DictaphoneStop"),
    _S("DictaphoneRecord"),
    _S("Help"),
    _S("Off"),
    _S("Dial"),
    _S("IncVolume"),
    _S("DecVolume"),
    _S("Device0"),
    _S("Device1"),
    _S("Device2"),
    _S("Device3"),
    _S("Device4"),
    _S("Device5"),
    _S("Device6"),
    _S("Device7"),
    _S("Device8"),
    _S("Device9"),
    _S("DeviceA"),
    _S("DeviceB"),
    _S("DeviceC"),
    _S("DeviceD"),
    _S("DeviceE"),
    _S("DeviceF"),
    _S("Application0"),
    _S("Application1"),
    _S("Application2"),
    _S("Application3"),
    _S("Application4"),
    _S("Application5"),
    _S("Application6"),
    _S("Application7"),
    _S("Application8"),
    _S("Application9"),
    _S("ApplicationA"),
    _S("ApplicationB"),
    _S("ApplicationC"),
    _S("ApplicationD"),
    _S("ApplicationE"),
    _S("ApplicationF"),
	_S("Yes"),
	_S("No"),
	_S("IncBrightness"),
	_S("DecBrightness"),
	NO_MORE_SCANCODEKEYS

};

//------------------------------------------------------------------------------
//This section represents the TStdScanCode values of the SCANCODES used by the end user with the L command

const TStdScanCode ENUM_VALSCANCODEArray[] =
{
	EStdKeyNull,
	EStdKeyBackspace,
	EStdKeyTab,
	EStdKeyEnter,
	EStdKeyEscape,
	EStdKeySpace,
	EStdKeyPrintScreen,
	EStdKeyPause,
	EStdKeyHome,
	EStdKeyEnd,
	EStdKeyPageUp,
	EStdKeyPageDown,
	EStdKeyInsert,
	EStdKeyDelete,
	EStdKeyLeftArrow,
	EStdKeyRightArrow,
	EStdKeyUpArrow,
	EStdKeyDownArrow,
	EStdKeyLeftShift,
	EStdKeyRightShift,
	EStdKeyLeftAlt,
	EStdKeyRightAlt,
	EStdKeyLeftCtrl,
	EStdKeyRightCtrl,
	EStdKeyLeftFunc,
	EStdKeyRightFunc,
	EStdKeyCapsLock,
	EStdKeyNumLock,
	EStdKeyScrollLock,
	EStdKeyF1,
	EStdKeyF2,
	EStdKeyF3,
	EStdKeyF4,
	EStdKeyF5,
	EStdKeyF6,
	EStdKeyF7,
	EStdKeyF8,
	EStdKeyF9,
	EStdKeyF10,
	EStdKeyF11,
	EStdKeyF12,
	EStdKeyF13,
	EStdKeyF14,
	EStdKeyF15,
	EStdKeyF16,
	EStdKeyF17,
	EStdKeyF18,
	EStdKeyF19,
	EStdKeyF20,
	EStdKeyF21,
	EStdKeyF22,
	EStdKeyF23,
	EStdKeyF24,
	EStdKeyXXX,
	EStdKeyComma,
	EStdKeyFullStop,
	EStdKeyForwardSlash,
	EStdKeyBackSlash,
	EStdKeySemiColon,
	EStdKeySingleQuote,
	EStdKeyHash,
	EStdKeySquareBracketLeft,
	EStdKeySquareBracketRight,
	EStdKeyMinus,
	EStdKeyEquals,
	EStdKeyNkpForwardSlash,
	EStdKeyNkpAsterisk,
	EStdKeyNkpMinus,
	EStdKeyNkpPlus,
	EStdKeyNkpEnter,
	EStdKeyNkp1,
	EStdKeyNkp2,
	EStdKeyNkp3,
	EStdKeyNkp4,
	EStdKeyNkp5,
	EStdKeyNkp6,
	EStdKeyNkp7,
	EStdKeyNkp8,
	EStdKeyNkp9,
	EStdKeyNkp0,
	EStdKeyNkpFullStop,
    EStdKeyMenu,
    EStdKeyBacklightOn,
    EStdKeyBacklightOff,
    EStdKeyBacklightToggle,
    EStdKeyIncContrast,
    EStdKeyDecContrast,
    EStdKeySliderDown,
    EStdKeySliderUp,
    EStdKeyDictaphonePlay,
    EStdKeyDictaphoneStop,
    EStdKeyDictaphoneRecord,
    EStdKeyHelp,
    EStdKeyOff,
    EStdKeyDial,
    EStdKeyIncVolume,
    EStdKeyDecVolume,
    EStdKeyDevice0,
    EStdKeyDevice1,
    EStdKeyDevice2,
    EStdKeyDevice3,
    EStdKeyDevice4,
    EStdKeyDevice5,
    EStdKeyDevice6,
    EStdKeyDevice7,
    EStdKeyDevice8,
    EStdKeyDevice9,
    EStdKeyDeviceA,
    EStdKeyDeviceB,
    EStdKeyDeviceC,
    EStdKeyDeviceD,
    EStdKeyDeviceE,
    EStdKeyDeviceF,
    EStdKeyApplication0,
    EStdKeyApplication1,
    EStdKeyApplication2,
    EStdKeyApplication3,
    EStdKeyApplication4,
    EStdKeyApplication5,
    EStdKeyApplication6,
    EStdKeyApplication7,
    EStdKeyApplication8,
    EStdKeyApplication9,
    EStdKeyApplicationA,
    EStdKeyApplicationB,
    EStdKeyApplicationC,
    EStdKeyApplicationD,
    EStdKeyApplicationE,
    EStdKeyApplicationF,
	EStdKeyYes,
	EStdKeyNo,
	EStdKeyIncBrightness,
	EStdKeyDecBrightness
};

//------------------------------------------------------------------------------

#endif
