::
:: Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
:: All rights reserved.
:: This component and the accompanying materials are made available
:: under the terms of the License "Symbian Foundation License v1.0"
:: which accompanies this distribution, and is available
:: at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
::
:: Initial Contributors:
:: Nokia Corporation - initial contribution.
::
:: Contributors:
:: 
:: Description: This file contains capsmodifier implementation.
::

@perl -x CreateKernelTestClass.bat %1 %2 %3 %4 %5 %6 %7 %8 %9 
@goto end

#!perl
use strict;
use File::Find;
use File::Path;
# Verify command line parameters
if   ($#ARGV == -1 || $#ARGV > 1 )
{
	PrintHelp();
}

# Take module name
my $moduleName = $ARGV[0];
my $MODULENAME = $moduleName;
$MODULENAME =~ tr/[a-z]/[A-Z]/;

# Take target path or use default
my $targetPath="\\";
if ( $#ARGV == 1 )
{
	$targetPath = $ARGV[1];
}


# Create directory
my $targetDir = $targetPath.$moduleName."\\";

print "Starting module creation to $targetDir\n";
mkpath($targetDir, 1, 0777) || die ("Can't create directory $targetDir");

# Loop through the file structure
find(\&renamerename, '.');

unlink $targetDir."CreateKernelTestClass.bat";
print "Module created to $targetDir\n";

# This function will be called for each file or directory
sub renamerename
{
	my $oldName = $_;
	print "Processing $oldName\n";

	# Construct new filename if that needed
	s/TemplateKernelScriptXXX/$moduleName/i;
	my $newName = $targetDir.$File::Find::dir."/".$_;  

	# Process directories
	if (opendir(DIR, $oldName))
	{
		closedir (DIR);
		mkdir $newName, 0777 || die ("Can't create directory $newName");
		return;
	}
                        
	# Open input file
	open (INFILE, $oldName ) || die ("Can not find $oldName");

	#Open output file
	my $newOutput = $newName."new";
	open (OUTFILE, ">".$newOutput ) || die ("Can not open $newOutput");

	# Replace text in files
	while (<INFILE>)
	{
	  s/TemplateKernelScriptXXX/$moduleName/g;
	  s/TEMPLATEKERNELSCRIPTXXX/$MODULENAME/g;
	  s/XXX/$moduleName/g;
	  s/TemplateKernelScriptTargetDirYYY/$targetDir/g;
	  print OUTFILE $_;
	}

	# Close filehandles
	close (INFILE);
	close (OUTFILE);

	# Rename result file
	rename $newOutput,$newName;
}

sub PrintHelp()
{
	print "CreateScriptModule ScriptModuleName [path]\n";
	print "\n";
	print "Creates a new test module\n";
	print "If [path] is not given, module is created to root of current drive.\n";
	print "If [path] is given, it must contain the final \'\\\' in path name.\n";
	print "Command must be executed in directory where the template exist.\n";
	exit;
}


__END__
:end
