/*
 * Copyright  2008 Nokia Corporation.
 */


#ifndef CALENDARAPIEXAMPLEENTRIESVIEW_H
#define CALENDARAPIEXAMPLEENTRIESVIEW_H

// INCLUDE FILES
#include <aknview.h>
#include "CalendarAPIExampleEngine.h"

// CONSTANTS
const TUid KEntriesViewId = {3};

// FORWARD DECLARATIONS
class CCalendarAPIexampleEntriesContainer;
//class CCalendarAPIexampleDocument;


// CLASS DECLARATION

class CCalendarAPIexampleEntriesView : public CAknView
    {
public: // Contructors and destructor

    CCalendarAPIexampleEntriesView(
        MCalendarEngineCommandsInterface& aEngine);
   /*!
    * Default constructor.
    */
    void ConstructL();

   /*!
    * Destructor.
    */
    virtual ~CCalendarAPIexampleEntriesView();

   /*!
    * Two-phased constructor.
    */
    static CCalendarAPIexampleEntriesView* NewL(MCalendarEngineCommandsInterface& aEngine);
    static CCalendarAPIexampleEntriesView* NewLC(MCalendarEngineCommandsInterface& aEngine);

public: // From CAknView

   /*!
    * From CAknView, Id.
    * Returns ID of View.
    */
    TUid Id() const;

   /*!
    * From CAknView, HandleCommandL.
    * Handles the commands. If the command is command which is required to
    * display outline-screen, the command is reported to container class.
    * param aCommand - Command to be handled.
    */
    void HandleCommandL( TInt aCommand );
    
private: // New functions

   /*!
    * DoDeleteL()
    *
    * Deletes the entry currently selected on the listbox
    */
    void DoDeleteL();
    
   /*!
    * DoEditL()
    *
    * Activates a proper view for editing an entry
    */  
    void DoEditL();

private: // From CAknView

   /*!
    * From CAknView, DoActivateL.
    * Creates the Container class object.
    * param aPrevViewId - aPrevViewId is not used.
    * param aCustomMessageId - aCustomMessageId is not used.
    * param aCustomMessage - aCustomMessage is not used.
    */
    void DoActivateL(   const TVwsViewId& aPrevViewId,
                        TUid aCustomMessageId,
                        const TDesC8& aCustomMessage );

   /*!
    * From CAknView, DoDeactivate.
    * Deletes the Container class object.
    */
    void DoDeactivate();

private: // Data members

    CCalendarAPIexampleEntriesContainer* iContainer;

    //a reference to the engine through its public interface
    MCalendarEngineCommandsInterface& iEngine;
    };

#endif
