/*
 * Copyright  2008 Nokia Corporation.
 */


#ifndef CALENDARAPIEXAMPLEENTRYCONTAINER_H
#define CALENDARAPIEXAMPLEENTRYCONTAINER_H

// INCLUDE FILES
#include <coecntrl.h> //CCoeControl
#include <calentry.h> //CCalEntry

// FORWARD DECLARATIONS
class CCalendarAPIexampleEntryItemList;
class CCalHelperEntry;
class CAknView;

// CLASS DECLARATION

class CCalendarAPIexampleEntryContainer :   public CCoeControl
    {
public: // Constructors and destructor

   /*!
    * Two-phased constructor.
    */
    static CCalendarAPIexampleEntryContainer* NewL(
                            const TRect& aRect,
                            const TDesC& aName,
                            const TDateTime& aDate,
                            const TBool& aAlarm,
                            const TDateTime& aAlarmTime,
                            const TInt& aSync);

   /*!
    * Destructor.
    */
    virtual ~CCalendarAPIexampleEntryContainer();

public : // New functions

   /*!
    * SaveL()
    * 
    * Saves data from itemlist to member entry object.
    */    
    TBool SaveL();
    
    void GetValues(TDes& aName, TTime& aDate,
                   TBool& aAlarm, TTime& aAlarmTime,
                            TInt& aSync);
                            
    void SetValues(         const TDesC& aName,
                            const TDateTime& aDate,
                            const TBool& aAlarm,
                            const TDateTime& aAlarmTime,
                            const TInt& aSync)  ;                                                      
    
    
private: // Basic two-phase Symbian OS constructors

   /*!
    * Symbian OS default constructor.
    */
    CCalendarAPIexampleEntryContainer();
    void ConstructL(const TRect& aRect,const TDesC& aName,
                            const TDateTime& aDate,
                            const TBool& aAlarm,
                            const TDateTime& aAlarmTime,
                            const TInt& aSync);
    
private: // Functions from base classes

    void SizeChanged();
    void HandleResourceChange(TInt aType);

   /*!
    * From CoeControl,CountComponentControls.
    */        
    TInt CountComponentControls() const; 
    
   /*!
    * From CCoeControl,ComponentControl.
    */
    CCoeControl* ComponentControl(TInt aIndex) const;
    
   /*!
    * From CCoeControl,OfferKeyEventL.
    */
    TKeyResponse OfferKeyEventL(const TKeyEvent& aKeyEvent, TEventCode aType );
    
private: // Data members

    CCalendarAPIexampleEntryItemList* iItemList;
    };

#endif
