/*
 * Copyright  2008 Nokia Corporation.
 */


#ifndef CALENDARAPIEXAMPLEENTRYITEMLIST_H
#define CALENDARAPIEXAMPLEENTRYITEMLIST_H

// INCLUDE FILES
#include <aknsettingitemlist.h>
#include "calendarapiexample.hrh"

// FORWARD DECLARATIONS
class CCalHelperEntry;
class CAknView;

// CLASS DECLARATION

class CCalendarAPIexampleEntryItemList : public CAknSettingItemList
    {
public: // New functions

   /*!
    * SetData()
    *
    * Sets values to itemlist from given entry.
    */
    void SetData(const CCalHelperEntry& aData);
        
   /*!
    * SaveL()
    *
    * Sets values from itemlist to given entry.
    * Returns true if user input is valid, otherwise false is returned.
    */
    TBool SaveL();

    /*!
     * Gets the values set.
     *
     *
     */
    void GetValues(TDes& aName, TTime& aDate,
                   TBool& aAlarm, TTime& aAlarmTime,
                            TInt& aSync);
    
    void SetValues(         const TDesC& aName,
                            const TDateTime& aDate,
                            const TBool& aAlarm,
                            const TDateTime& aAlarmTime,
                            const TInt& aSync);                            
   /*!
    * From CCoeControl,SizeChanged
    */

private: // Functions from base classes

   /*!
    * From CAknSettingItemList,CreateSettingItemL
    */
    CAknSettingItem* CreateSettingItemL( TInt aIdentifier );

    
private: // Data members

    TBuf<KMaxNameLength> iName;
    TTime iDate;
    TBool iAlarm;
    TTime iAlarmDate;
    TTime iAlarmTime;
    TInt iSync;

    };

#endif
