/*
 * Copyright  2008 Nokia Corporation.
 */


// INCLUDE FILES
#include "CalendarAPIexampleAppUi.h"
#include "CalendarAPIexampleSearchView.h"
#include "CalendarAPIexampleEntryView.h"
#include "CalendarAPIexampleEntriesView.h"

#include "CalendarAPIexampleEngine.h"
#include "CalendarAPIexampleDocument.h"
#include "CalendarAPIexample.pan"

#include <avkon.hrh>

// ================= MEMBER FUNCTIONS =======================
//
// ----------------------------------------------------------
// CCalendarAPIexampleAppUi::ConstructL()
// 
// ----------------------------------------------------------
//
void CCalendarAPIexampleAppUi::ConstructL()
    {
    BaseConstructL(EAknEnableSkin | EAknTouchCompatible | EAknSingleClickCompatible);
    
    iEngine = CCalendarAPIexampleEngine::NewL(*this);    
    
    iSearchView = CCalendarAPIexampleSearchView::NewL(*iEngine);
    AddViewL( iSearchView );      // transfer ownership to AppUi

    iEntryView = CCalendarAPIexampleEntryView::NewL(*iEngine);
    AddViewL( iEntryView );      // transfer ownership to AppUi

    iEntriesView = CCalendarAPIexampleEntriesView::NewL(*iEngine);
    AddViewL( iEntriesView );      // transfer ownership to AppUi

    ActivateView(iSearchView->Id());
    }

// ----------------------------------------------------
// CCalendarAPIexampleAppUi::~CCalendarAPIexampleAppUi()
// Destructor
// Frees reserved resources
// ----------------------------------------------------
//
CCalendarAPIexampleAppUi::~CCalendarAPIexampleAppUi()
    {
    delete iEngine;
    iEngine=NULL;
    }

// ----------------------------------------------------
// CCalendarAPIexampleAppUi::HandleCommandL(TInt aCommand)
// takes care of command handling
// ----------------------------------------------------
//
void CCalendarAPIexampleAppUi::HandleCommandL(TInt aCommand)
    {
    switch ( aCommand )
        {
        case EAknSoftkeyBack:
        case EEikCmdExit:
            {
            Exit();
            break;
            }
        default:
            break;      
        }
    }

void CCalendarAPIexampleAppUi::ActivateView(TUid aViewId)
    {
    TRAPD(err,ActivateLocalViewL(aViewId) );
    if( err )
        {
        Panic(EViewError);
        }
    }

// End of File  
