/*
 * Copyright  2008 Nokia Corporation.
 */

// INCLUDE FILES
#include "CalendarAPIexampleEntriesContainer.h"
#include "CalendarAPIexampleEngine.h"
#include "CalendarAPIexampleAppUi.h"
#include "CalendarAPIexampleSearchView.h"

// CONSTANTS
const TInt KMaxEntryItemLength = KMaxNameLength + 25;
const TInt KMaxDateLength = 12;

// ================= MEMBER FUNCTIONS =======================

// constructor
CCalendarAPIexampleEntriesContainer::CCalendarAPIexampleEntriesContainer(
        CCalendarAPIexampleEntriesView& aView, 
        MCalendarEngineCommandsInterface& aEngine) :
        iEntriesView(aView), iEngine(aEngine)
        {
        }
        
// destructor
CCalendarAPIexampleEntriesContainer::~CCalendarAPIexampleEntriesContainer()
    {
    delete iEntryListBox;
    iEntryListBox=NULL;
    }
    
// Two-phased constructor.
CCalendarAPIexampleEntriesContainer* CCalendarAPIexampleEntriesContainer::NewL(
                                        const TRect& aRect,
                                        CCalendarAPIexampleEntriesView& aView,
                                        MCalendarEngineCommandsInterface& aEngine)
    {
    CCalendarAPIexampleEntriesContainer* self = 
        new (ELeave) CCalendarAPIexampleEntriesContainer(aView, aEngine);
    CleanupStack::PushL(self);
    self->ConstructL(aRect);
    CleanupStack::Pop(self);
    return self;
    }
    
// Symbian OS default constructor can leave.    
void CCalendarAPIexampleEntriesContainer::ConstructL(const TRect& aRect)
    {
    CreateWindowL();    

    iEntryListBox = new (ELeave) CAknDoubleNumberStyleListBox;
    iEntryListBox->SetContainerWindowL(*this);  
    iEntryListBox->ConstructL(this, EAknListBoxSelectionList);
    // To get event in HandleListBoxEventL()
    iEntryListBox->SetListBoxObserver(this);
    iEntryListBox->CreateScrollBarFrameL(ETrue);
    iEntryListBox->ScrollBarFrame()->SetScrollBarVisibilityL(   
                                            CEikScrollBarFrame::EOff,
                                            CEikScrollBarFrame::EAuto);
    PopulateListBoxL();
    SetRect(aRect);
    ActivateL();    
    }
    

    
// ----------------------------------------------------
// CCalendarAPIexampleEntriesContainer::CountComponentControls()
// Gets the number of controls contained in a compound 
// control. 
// ----------------------------------------------------
//
TInt CCalendarAPIexampleEntriesContainer::CountComponentControls() const
    {
    TInt count = 0;
    if (iEntryListBox)
        count++;
    return count;
    }
    
// ----------------------------------------------------
// CCalendarAPIexampleEntriesContainer::ComponentControl()
// Gets the specified component of a compound control.
// ----------------------------------------------------
//  
CCoeControl* CCalendarAPIexampleEntriesContainer::ComponentControl(
                                                        TInt /*aIndex*/) const
    {
    return iEntryListBox;
    }
    
// ----------------------------------------------------
// CCalendarAPIexampleEntriesContainer::OfferKeyEventL()
// When a key event occurs, the control framework calls 
// this function for each control on the control stack, 
// until one of them can process the key event 
// (and returns EKeyWasConsumed).
// ----------------------------------------------------
//      
TKeyResponse CCalendarAPIexampleEntriesContainer::OfferKeyEventL(   
                                                    const TKeyEvent& aKeyEvent,
                                                    TEventCode aType )
    {
    if(aType != EEventKey)
        {
        return EKeyWasNotConsumed;
        }    
    else if(iEntryListBox)
        {
        return iEntryListBox->OfferKeyEventL( aKeyEvent, aType );
        }
    else
        {
        return EKeyWasNotConsumed;
        }   
    }   
    
// ----------------------------------------------------
// CCalendarAPIexampleEntriesContainer::PopulateListBoxL()
// Get all found entries from model, format their data
// for listbox and show them.
// ----------------------------------------------------
//  
void CCalendarAPIexampleEntriesContainer::PopulateListBoxL()
    {
    CDesCArray* entryArray = static_cast<CDesCArray*>(
        iEntryListBox->Model()->ItemTextArray()
        );
        
    entryArray->Reset();

    TInt entryCount = iEngine.EntryCount();
    
    for (TInt i = 0; i < entryCount; i++)
        {
        const CCalHelperEntry& entry = iEngine.Entry(i);
        
        
        
        TBuf<KMaxDateLength> entryDate;
        _LIT(KDateFormat, "%D%M%Y%/0%1%/1%2%/2%3%/3");
        TTime date(entry.Date());
        date.FormatL(entryDate, KDateFormat);
        
        _LIT(KEntryFormat, "%d\t%S\t%S \t");
        TBuf<KMaxEntryItemLength> entryItem;
        TBuf<KMaxNameLength> name = entry.Name();
        
        entryItem.Format(KEntryFormat, i+1, &name, &entryDate);
        entryArray->AppendL(entryItem);
        }
        
    iEntryListBox->HandleItemAdditionL();
    iEntryListBox->SetCurrentItemIndex(0);
    }
    
// ----------------------------------------------------
// CCalendarAPIexampleEntriesContainer::CurrentItemIndex()
// Returns the index of the entry currently selected on 
// the listbox.
// ----------------------------------------------------
//  
TInt CCalendarAPIexampleEntriesContainer::CurrentItemIndex() const
    {
    return iEntryListBox->CurrentItemIndex();
    }
    
// ----------------------------------------------------
// CCalendarAPIexampleEntriesContainer::HandleListBoxEventL()
// Handles listbox events.
// ----------------------------------------------------
//  
void CCalendarAPIexampleEntriesContainer::HandleListBoxEventL(CEikListBox* /*aListBox*/, TListBoxEvent aEventType)
    {
    if (aEventType == EEventEnterKeyPressed  || aEventType == EEventItemSingleClicked)
        {
        iEntriesView.HandleCommandL(ECalendarAPIexampleCmdEdit);
        }
    }

// ----------------------------------------------------
// CCalendarAPIexampleEntriesContainer::SizeChanged()
// Responds to size changes to sets the size and 
// position of the contents of this control. 
// ----------------------------------------------------
//              
void CCalendarAPIexampleEntriesContainer::SizeChanged()
    {
    iEntryListBox->SetRect(Rect());
    }

void CCalendarAPIexampleEntriesContainer::HandleResourceChange(TInt aType)
    {
    CCoeControl::HandleResourceChange(aType);
    if ( aType==KEikDynamicLayoutVariantSwitch )
        {
        TRect rect;
        AknLayoutUtils::LayoutMetricsRect(AknLayoutUtils::EMainPane, rect);
        SetRect(rect);
        }
    }

// End of File
