/*
 * Copyright  2008 Nokia Corporation.
 */

// INCLUDE FILES
#include "CalendarAPIexampleEntryItemList.h"
#include "CalendarHelperEntry.h"
#include "CalendarAPIexampleEntryView.h"
#include <AknQueryDialog.h>

// ================= MEMBER FUNCTIONS =======================


// ----------------------------------------------------
// CCalendarAPIexampleEntryItemList::CreateSettingItemL()
// Framework method to create a setting item based upon 
// the user id aSettingId. The client code decides what
// type to construct. new (ELeave) must then be used and
// the resulting pointer returned. Ownership is 
// thereafter base class's responsibility.
// ----------------------------------------------------
//
CAknSettingItem* CCalendarAPIexampleEntryItemList::CreateSettingItemL( 
                                                            TInt aIdentifier )
    {   
    CAknSettingItem* settingItem = NULL;

    // create a setting item for each setting list resource
    switch (aIdentifier)
    {
    case ECalendarAPIexampleNameItem:
        {
        settingItem = new (ELeave) CAknTextSettingItem(aIdentifier, iName);
        break;
        }
    case ECalendarAPIexampleDateItem:
        settingItem = new (ELeave)  CAknTimeOrDateSettingItem(  
                                            aIdentifier, 
                                            CAknTimeOrDateSettingItem::EDate,
                                            iDate);
        break;
    case ECalendarAPIexampleAlarmItem:
        settingItem = new (ELeave) CAknBinaryPopupSettingItem(aIdentifier, 
                                                              iAlarm);
        break;
    case ECalendarAPIexampleAlarmTimeItem:
        settingItem = new (ELeave)  CAknTimeOrDateSettingItem(
                                            aIdentifier, 
                                            CAknTimeOrDateSettingItem::ETime,
                                            iAlarmTime);
        break;
    case ECalendarAPIexampleAlarmDateItem:
        settingItem = new (ELeave)  CAknTimeOrDateSettingItem(  
                                            aIdentifier, 
                                            CAknTimeOrDateSettingItem::EDate,
                                            iAlarmDate);
        break;
    case ECalendarAPIexampleSyncItem:
        settingItem = new (ELeave) CAknEnumeratedTextPopupSettingItem(  aIdentifier, 
                                                                        iSync);
        break;
    default:
        break;
        }
    return settingItem;
    
    }


    
// ----------------------------------------------------
// CCalendarAPIexampleEntryItemList::SetData()
// Reads values to each item in item list from the given
// entry.
// ----------------------------------------------------
//  
void CCalendarAPIexampleEntryItemList::SetData(const CCalHelperEntry& aData)
    {
    iName = aData.Name();
    iDate = aData.Date();
    iAlarm = (aData.Alarm() != 0);
    iAlarmTime = aData.AlarmTime();
    iAlarmDate = aData.AlarmTime();
    iSync = aData.SynchronizationMethod();
    }
    
// ----------------------------------------------------
// CCalendarAPIexampleEntryItemList::SaveL()
// Sets value from itemlist to the given entry. Returns
// false if user input was invalid, otherwise true is
// returned.
// ----------------------------------------------------
//  
TBool CCalendarAPIexampleEntryItemList::SaveL()
    {
    StoreSettingsL();
    return ETrue;
    }

void CCalendarAPIexampleEntryItemList::GetValues(TDes& aName, TTime& aDate,
                   TBool& aAlarm, TTime& aAlarmTime,
                            TInt& aSync)
    {
    TDateTime alarmTime = iAlarmTime.DateTime();
    TDateTime alarmDate = iAlarmDate.DateTime();
    
    alarmTime.SetYear(alarmDate.Year());
    alarmTime.SetMonth(alarmDate.Month());
    alarmTime.SetDay(alarmDate.Day());    
    
    aName = iName;
    aDate = iDate;
    aAlarm = iAlarm;
    aAlarmTime = alarmTime;
    aSync = iSync;    
    
    }

void CCalendarAPIexampleEntryItemList::SetValues(
                            const TDesC& aName,
                            const TDateTime& aDate,
                            const TBool& aAlarm,
                            const TDateTime& aAlarmTime,
                            const TInt& aSync)                            
    {
    iName = aName;
    iDate = aDate;
    iAlarm = aAlarm;
    iAlarmTime = aAlarmTime;
    iAlarmDate = aAlarmTime;
    iSync = aSync;    
    }


// End of File
