// Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#ifndef __BIOMESSAGE_H__
#define __BIOMESSAGE_H__


#include "BIOParser.h"

#include <sendas2.h>
#include <csendasaccounts.h>
#include <csendasmessagetypes.h>

// System Includes
#include <e32cons.h>

_LIT(KTestTitle, "BIO Parser Example" );

_LIT(KBodyText, "Every man passes his life in the search after friendship.");
_LIT(KAddress1, "9980501111");
_LIT(KAddress3, "9980502222");
_LIT(KAddress4, "9980503333");
_LIT(KAlias1, "alias1");
_LIT(KAlias2, "alias2");
_LIT(KSubject, "HELLO");

class CDummyObserver;
class CBioMessage : public CBase
{
public:
	static CBioMessage* NewL();
	~CBioMessage();
	void StartL();

	void Connect();
	void CreateL(RSendAsMessage& aMessage);
	void SendL(RSendAsMessage& aMessage);
	void ParseL();

private:
	CBioMessage();
	void ConstructL();
	void CleanMailFolderL(TMsvId aFolderId);

private:
	CConsoleBase* 			iConsole;

	RSendAs 				iSendAs;	
	CDummyObserver* 		iObserver;
	CMsvSession* 			iSession;
	CMsvEntry* 				iEntry;
	CMsvEntrySelection* 	iSelection;
};


class CDummyObserver : public CBase, public MMsvSessionObserver
{
public:
	void HandleSessionEventL(TMsvSessionEvent, TAny*, TAny*, TAny*) {};
};

#endif /*__BIOMESSAGE_H__*/
