// Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#ifndef __BIOPARSER_H__
#define __BIOPARSER_H__


// system Includes
#include <e32base.h>
#include <bsp.h>
#include <biodb.h>
#include <msvreg.h>
#include <msvids.h>
#include <regpsdll.h>

#include "BIOExampleParser.h"

const TUid	KUidBIOVCardMsg = {0x10005534};    // VCard contact entries
_LIT(KBifDir,"\\" );


class CBioParser : CBase
{
public:
	static CBioParser* NewL(CMsvEntry* aEntry);
	~CBioParser();

	void ParserL();

private:
	CBIOExampleParser* CreateParserL();
	void ExtractMessageBodyL();
	CBioParser(CMsvEntry* aEntry);
	void ConstructL();

public:
	CRegisteredParserDll*	iRegisteredParserDll;
	CBIODatabase*			iBioDb;
	RFs 					iFs;
	CMsvEntry*				iMsvEntry;
	HBufC*					iMessageBody;
};

#endif /*__BIOPARSER_H__*/
