// Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//


#include <e32std.h>
#include <eikenv.h>

#include "BIOExampleParser.h"

CBIOExampleParser::CBIOExampleParser(CRegisteredParserDll& aRegisteredParserDll, CMsvEntry& aEntry, RFs& aFs)
:CBaseScriptParser2(aRegisteredParserDll, aEntry, aFs)
    {
    }

CBIOExampleParser::~CBIOExampleParser()
	{
	Cancel();
	}
	
EXPORT_C CBIOExampleParser* CBIOExampleParser::NewL(CRegisteredParserDll& aRegisteredParserDll, CMsvEntry& aEntry, RFs& aFs)
	{
    CBIOExampleParser* self = new(ELeave) CBIOExampleParser(aRegisteredParserDll, aEntry, aFs);
    CleanupStack::PushL(self);
    self->ConstructL();
    CleanupStack::Pop();
    return self;
	}

void CBIOExampleParser::ConstructL()
	{
	CActiveScheduler::Add(this);
	}

/**
Parsing the message.
@param aStatus An TRequestStatus reference, used to return the status
@param aSms An TDesC reference
*/
void CBIOExampleParser::ParseL(TRequestStatus& aStatus, const TDesC& /*aSms*/)
	{
	aStatus = iStatus;
	SetActive();

	TMsvEntry entry = iEntry.Entry();
	entry.iMtmData3 = 1;
	iEntry.ChangeL(entry);

	TRequestStatus* status = &aStatus ;
	User::RequestComplete(status, KErrNone);
	}

/**
Processing the message.
@param aStatus An TRequestStatus reference, used to return the status
*/
void CBIOExampleParser::ProcessL(TRequestStatus& aStatus)
	{
	aStatus = iStatus;
	SetActive();

	TRequestStatus* status = &iStatus;
	User::RequestComplete(status, KErrNone);
	}

void CBIOExampleParser::DoCancel()
	{
	TRequestStatus* status = &iStatus;
	User::RequestComplete(status, KErrCancel);
	}

void CBIOExampleParser::RunL()
	{
	}


