// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains CCircularBufferExample class.
//



/**
 @file
*/
#ifndef __CIRCULARBUFFEREXAMPLE_H__
#define __CIRCULARBUFFEREXAMPLE_H__

#include <e32cons.h>

/**
Demonstrates the following uses of the Symbian platform circular buffer API:

- Creating a circular buffer.
- Adding elements to the circular buffer
- Removing elements from the circular buffer
*/
class CCircularBufferExample: public CBase
	{
public:
	static CCircularBufferExample* NewL();
	~CCircularBufferExample();
 	void CircularBufferOfIntsL();
	void CircularBufferOfMyObjectsL();
	void CircularBufferOfRClasssL();

private:
	CCircularBufferExample();
	void ConstructL();
private:
	/** Pointer to console interface */
	CConsoleBase* iConsole;
	};

/**
Demonstrates a simple class containing a simple buffer and methods 
- create a text buffer using new value
- to set value to buffer
- retrieve buffer's value
*/	

class TMyClass
	{
public:
	TMyClass();
	TMyClass(const TDesC& aDes);
	void SetBuf(const TDesC& aDes);
	const TDesC& GetBuf();
private:
	// Simple buffer to hold text
	TBufC<16> iBuf;
 };



#endif //__CIRCULARBUFFEREXAMPLE_H__
