/*
 * Copyright  2008 Nokia Corporation.
 */

#ifndef TZLOCALIZERAPPUI_H
#define TZLOCALIZERAPPUI_H

// INCLUDES
#include <eikapp.h>
#include <eikdoc.h>
#include <e32std.h>
#include <coeccntx.h>
#include <aknappui.h>
#include <eikdialg.h>
#include <TzLocalizationDataTypes.h>

// FORWARD DECLARATIONS
class CTZLocalizerDialog;
class CTZLocalizerEngine;


// CLASS DECLARATION
enum TCurrentlyShowing
    {
    EShowingNothing = 1,
    EShowingCity,
    EShowingCountry
    };


class CTZLocalizerAppUi : public CAknAppUi
    {
    public: // // Constructors and destructor

        void ConstructL();
        virtual ~CTZLocalizerAppUi();
        
    private:
        void DynInitMenuPaneL( TInt aResourceId,CEikMenuPane* aMenuPane );
    
        void FillListBoxL( CTzLocalizedCity* aLocalizedCity  );
    
        void FillListBoxL( CDesC16ArrayFlat* aArray );
    
        void ClearListBoxL();
        
        void ShowInfoL( const TPtrC aText );
    
        TBool QueryTextL( const TPtrC aPrompt, TDes& aReturn );
    
        TBool AskPopupChoiseL( const TPtrC aPrompt, 
            CDesC16ArrayFlat* aList, TDes& aReturn );
    
        void CreateNewCityL();
            
        void SearchCitiesL();
    
        void DeleteCityL();
            
        void HandleCommandL( TInt aCommand );
    
        virtual TKeyResponse HandleKeyEventL(
            const TKeyEvent& aKeyEvent,TEventCode aType);
    
        void SearchCitiesInGroupsL();
        void HandleResourceChangeL( TInt aType );
        
    private: //Data
        CTZLocalizerDialog* iAppDialog;
        CTZLocalizerEngine* iTzEngine;
    };

#endif

// End of File
