/*
 * Copyright  2008 Nokia Corporation.
 */

#ifndef CTZLOCALIZERENGINE_H
#define CTZLOCALIZERENGINE_H

#include <tz.h>
#include <TzLocalizer.h>
#include <TzLocalizationDataTypes.h>

class CTZLocalizerEngine : public CBase  
    {
    public:

        static CTZLocalizerEngine* NewL();
        static CTZLocalizerEngine* NewLC();

        /**
         * Destructor.
         */
        ~CTZLocalizerEngine();

    private:    // Constructors
        CTZLocalizerEngine();
        
// ---------------------------------------------------------
//  CTZLocalizerEngine::ConstructL()
//  Connect to Time Zone server. 
// ---------------------------------------------------------
        void ConstructL();

    public:     // Methods

// ---------------------------------------------------------
//  CTZLocalizerEngine::ListCitiesL()
//  Fills aCityListReturn with the names of the cities of
//  whose name match to aSearchPattern.
// ---------------------------------------------------------
    void ListCitiesL( const TDesC& aSearchPattern, 
            CDesC16ArrayFlat* aCityListReturn );

// ---------------------------------------------------------
// CTZLocalizerEngine::RemoveCityL()
// Removes a city from the user defined city collection 
// ---------------------------------------------------------
    void RemoveCityL(const TDesC& aCityName );

// ---------------------------------------------------------
// TPtrC CTZLocalizerEngine::GetCityName(CTzLocalizedCity *aLocalizedCity)
// Get current city name.
// ---------------------------------------------------------
    TPtrC GetCityName(CTzLocalizedCity *aLocalizedCity);

// ---------------------------------------------------------
// CTZLocalizerEngine::GetCityTimeZoneId(CTzLocalizedCity *aLocalizedCity)
// Get current city time zone id.
// ---------------------------------------------------------    
    TUint16 GetCityTimeZoneId(CTzLocalizedCity *aLocalizedCity);

// ---------------------------------------------------------
// CTZLocalizerEngine::GetCityGroupId(CTzLocalizedCity *aLocalizedCity)
// Get current city group id.
// ---------------------------------------------------------
    TUint8 GetCityGroupId(CTzLocalizedCity *aLocalizedCity);

// ---------------------------------------------------------
// CTZLocalizerEngine::GetCityLocalTime()
// Convert universal time to local time.
// ---------------------------------------------------------    
    HBufC* GetCityLocalTimeL(CTzLocalizedCity *aLocalizedCity);

// ---------------------------------------------------------
// CTZLocalizerEngine::FindCitiesInGroupL()
// Find the cities with same group id.
// ---------------------------------------------------------
    CDesC16ArrayFlat* FindCitiesInGroupL( TInt aGroupID);

// ---------------------------------------------------------
//  CTZLocalizerEngine::AddCityL()
//  Add a new city to the database.
// ---------------------------------------------------------    
    CTzLocalizedCity* AddCityL(TInt aTimeZoneId, const TDesC &aCityName, TInt aGroupId=0);

// ---------------------------------------------------------
// CTZLocalizerEngine::FindCityL()
// Find the specific city.
// ---------------------------------------------------------    
    CTzLocalizedCity* FindCityL(const TDesC& aCityName);
    
// ---------------------------------------------------------
//  CTZLocalizerEngine::GetAllTimeZonesL()
//  Fetch the localized time zone ID's
// ---------------------------------------------------------
    CDesC16ArrayFlat* GetAllTimeZonesL();

// ---------------------------------------------------------
// CTZLocalizerEngine::GetAllGroupID()
// Fetch the localized city group ID's
// ---------------------------------------------------------    
    CDesC16ArrayFlat* GetAllGroupIDL();
    
// ---------------------------------------------------------
// CDesC16ArrayFlat* CTZLocalizerEngine::GetAllCitiesL()
// Fetch the localized cities
// ---------------------------------------------------------    
    CDesC16ArrayFlat* GetAllCitiesL();

    private:    // Data

};

#endif

// End of File

