/*
 * Copyright  2008 Nokia Corporation.
 */

// INCLUDE FILES
#include    "TZLocalizerApp.h"
#include    "TZLocalizerDocument.h"
#include <eikstart.h>

// ================= MEMBER FUNCTIONS =======================

// ---------------------------------------------------------
// CTZLocalizerApp::AppDllUid()
// Returns application UID
// ---------------------------------------------------------
//
TUid CTZLocalizerApp::AppDllUid() const
    {
    return KUidTZLocalizer;
    }

   
// ---------------------------------------------------------
// CTZLocalizerApp::CreateDocumentL()
// Creates CTZLocalizerDocument object
// ---------------------------------------------------------
//
CApaDocument* CTZLocalizerApp::CreateDocumentL()
    {
    return CTZLocalizerDocument::NewL( *this );
    }

// ================= OTHER EXPORTED FUNCTIONS ==============
//
// ---------------------------------------------------------
// NewApplication() 
// Constructs CTZLocalizerApp
// Returns: created application object
// ---------------------------------------------------------
//
EXPORT_C CApaApplication* NewApplication()
    {
    return new CTZLocalizerApp;
    }

// ---------------------------------------------------------
// E32Main()
// Entry point function for new (>= 9.0) EPOC Apps (exe)
// Returns: Sistem Wide error codes or KErrNone if all goes well
// ---------------------------------------------------------
//
GLDEF_C TInt E32Main()
{
    return EikStart::RunApplication( NewApplication );
}


// End of File  

