/*
 * Copyright  2008 Nokia Corporation.
 */

// INCLUDE FILES
#include    "TZLocalizerDialog.h"

#include <avkon.hrh>
#include <aknappui.h>

#include "TZLocalizer.hrh"

// ================= MEMBER FUNCTIONS =======================


// Destructor
CTZLocalizerDialog::~CTZLocalizerDialog()
    {
    }

// ---------------------------------------------------------
// CTZLocalizerDialog::OkToExitL(TInt aButtonId)
// called by framework when the OK button is pressed
// ---------------------------------------------------------
TBool CTZLocalizerDialog::OkToExitL(TInt aButtonId)
{
    if ( aButtonId == EAknSoftkeyOptions )
        {
        iAvkonAppUi->ProcessCommandL( EAknSoftkeyOptions );
        }
    else if ( aButtonId == EAknSoftkeyExit )
        {
        iAvkonAppUi->ProcessCommandL( EEikCmdExit );
        }
    
    return EFalse;
}

// ---------------------------------------------------------
// CTZLocalizerDialog::PreLayoutDynInitL();
// called by framework before dialog is shown 
// ---------------------------------------------------------
void CTZLocalizerDialog::PreLayoutDynInitL()
    {
    CEikDialog::PreLayoutDynInitL();
    SetEditableL(ETrue);    
    }

void CTZLocalizerDialog::SetSizeAndPosition(const TSize& /*aSize*/)
    {
    TRect rect;
    AknLayoutUtils::LayoutMetricsRect(AknLayoutUtils::EMainPane,rect);
    CEikDialog::SetSizeAndPosition(rect.Size());
    SetRect(rect);
    }

// ---------------------------------------------------------
// CTZLocalizerDialog::SetListBoxText();
// Set the main dialog listbox texts to aArray 
// ---------------------------------------------------------
void CTZLocalizerDialog::SetListBoxTextL( CDesC16ArrayFlat* aArray )
    {
    CEikTextListBox* listBox = 
        static_cast <CEikTextListBox*>(ControlOrNull(ETZLocalizerDlgList));

    CDesCArray* listArray = 
        static_cast<CDesCArray*>(listBox->Model()->ItemTextArray());
    
    listBox->CreateScrollBarFrameL(ETrue);
    listBox->ScrollBarFrame()->SetScrollBarVisibilityL(
        CEikScrollBarFrame::EOn, CEikScrollBarFrame::EAuto );
    
    listArray->Reset();

    for( TInt c = 0; c < aArray->Count(); c++ )
        {
        listArray->AppendL( (*aArray)[c] );
        }

    listBox->HandleItemAdditionL();
    listBox->SetCurrentItemIndexAndDraw( 0 );
    }

// End of File

