/*
 * Copyright  2008 Nokia Corporation.
 */

#ifndef SMS_EXAMPLE_RTE_CONTAINER_H
#define SMS_EXAMPLE_RTE_CONTAINER_H

#include <coecntrl.h>
#include <eikrted.h>  // CEikRichTextEditor
#include <txtfrmat.h> // TCharFormat, TCharFormatMask
   
/**
 * Container control class.
 */
class CSMSExampleRTEContainer : public CCoeControl
    {
    public:  // Constructors and destructor
        /**
         * Symbian OS two-phased constructor.
         * @param aRect Frame rectangle for container.
         * @return a pointer to the created instance of CSMSExampleRTEContainer.
         */
        static CSMSExampleRTEContainer* NewL(const TRect& aRect);

        /**
         * Symbian OS two-phased constructor.
         */ 
        static CSMSExampleRTEContainer* NewLC(const TRect& aRect);

        /**
         * Symbian OS default constructor.
         * @param aRect Frame rectangle for container.
         */
        void ConstructL(const TRect& aRect);

        /**
         * Destructor.
         */
        ~CSMSExampleRTEContainer();

    public:  // New functions
        /**
         * Print text on the screen. No Carriage return at the end.
         * @param aText text to be displayed.
         */
        void DrawTextWithoutCarriageL( const TDesC& aText );

        /**
         * Print text on the screen.
         * @param aText text to be displayed.
         */
        void DrawTextL( const TDesC& aText );

        /**
         * Add one line break.
         */ 
        void AddCarriageReturnL();

        /**
         * Print underlined text on the screen.
         * @param aText text to be displayed.
         */
        void DrawUnderlinedTextL( const TDesC& aText );

        /**
         * Draw one line.
         */
        void DrawLineL();

    private:  // New functions
        /**
         * Returns the width (breadth) of the scrollbar for the editor
         */
        TInt GetScrollbarWidth() const;
        
    private:  // Functions from base classes
        /**
         * From CoeControl.
         */
        void SizeChanged();

        /**
         * From CoeControl.
         */
        TInt CountComponentControls() const;

        /**
         * From CCoeControl.
         */
        CCoeControl* ComponentControl(TInt aIndex) const;

        /**
         * From CCoeControl.
         */
        void Draw(const TRect& aRect) const;

        /**
         * From CoeControl.
         */
        TKeyResponse OfferKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType);

    private:  // Data
        CEikRichTextEditor* iRTE;
        // Formatting options for the RTE
        TCharFormatMask iCharacterFormatMask;
        TCharFormat iCharacterFormat;
    };

#endif // SMS_EXAMPLE_RTE_CONTAINER_H
