/*
 * Copyright  2008 Nokia Corporation.
 */

// INCLUDE FILES
#include "SMSExampleAppui.h"
#include <SMSExample.rsg>
#include "SMSExample.hrh"
#include "SMSExampleLogView.h"
#include "SMSExampleListboxView.h"
#include "SmsExamplePanics.pan"
#include "SMSExampleParser.h"

#include <AknQueryDialog.h>
#include <msvids.h> // Folder Ids
#include <txtrich.h> // CRichText
#include <smut.h>
#include <AknGlobalNote.h>  //avkon.lib, aknnotify.lib

#ifdef __WINS__
const TMsvId KObservedFolderId = KMsvDraftEntryId;
#else
const TMsvId KObservedFolderId =  KMsvGlobalInBoxIndexEntryId;
#endif

const TMsvId KInbox = KMsvGlobalInBoxIndexEntryId;
const TMsvId KOutbox = KMsvGlobalOutBoxIndexEntryId;
const TMsvId KDrafts = KMsvDraftEntryId;

_LIT(KCouldNotSendSMS, "Message not sent");
_LIT(KSentMessageToAddress, "Sent message to address: ");
_LIT(KNoBodyText, "No body text");
_LIT(KAutomaticDeletedMesssageText, "Deleted arrived message!");
_LIT(KAutomaticDeleteActivatedText, "Automatic delete activated");
_LIT(KAutomaticDeleteDeActivatedText, "Automatic delete deactivated");
_LIT(KSendingMsgTxt,"Sending msg");
_LIT(KErrText,"Error:");
_LIT(KEngineInitializedTxt,"Engine initialized");
_LIT(KMessageSentTxt,"Message sent");
_LIT(KMsgReceivedTxt,"Received message");

const TInt KDelayTime = 1000*3000;
const TInt KErrMsgLength = 20;

#define KErrMsgLength 30

void CSMSExampleAppUi::ConstructL()
    {
    BaseConstructL(EAknEnableSkin);

    iAutomaticDelete = EFalse;

    iSmsEngine = CSmsEngine::NewL(*this);

    iLogView = CLogView::NewL();
    iListboxView = CListboxView::NewL(iSmsEngine, iLogView);

    AddViewL(iLogView); // Transfer ownership to base class
    AddViewL(iListboxView); // Transfer ownership to base class

    SetDefaultViewL(*iLogView); // Start with log view.

    // Message body parser
    iParser = CSMSExampleParser::NewL();
    }

// Destructor frees reserved resources
CSMSExampleAppUi::~CSMSExampleAppUi()
    {
    delete iParser;
    iParser = NULL;

    delete iSmsEngine;
    iSmsEngine = NULL;
    }

//  This function is called by the EIKON framework just before it displays
//  a menu pane. Its default implementation is empty, and by overriding it,
//  the application can set the state of menu items dynamically according
//  to the state of application data.
void CSMSExampleAppUi::DynInitMenuPaneL(
    TInt /*aResourceId*/,CEikMenuPane* /*aMenuPane*/)
    {
    }

// takes care of key event handling
TKeyResponse CSMSExampleAppUi::HandleKeyEventL(
    const TKeyEvent& /*aKeyEvent*/,TEventCode /*aType*/)
    {
    return EKeyWasNotConsumed;
    }

// Query message recipient from the user.
TInt CSMSExampleAppUi::GetAddressL()
    {
    CAknTextQueryDialog* dlg = new (ELeave) CAknTextQueryDialog(iAddress,
        CAknQueryDialog::ENoTone);

    return dlg->ExecuteLD(R_MTMS_EXAMPLE_ADDRESS_QUERY);
    }

// Query message body from the user.
TInt CSMSExampleAppUi::QueryMessageL()
    {
    CAknTextQueryDialog* dlg = new (ELeave) CAknTextQueryDialog(iMessage,
        CAknQueryDialog::ENoTone);

    return dlg->ExecuteLD(R_MTMS_EXAMPLE_MESSAGE_QUERY);
    }

// Takes care of command handling.
void CSMSExampleAppUi::HandleCommandL(TInt aCommand)
    {
    switch ( aCommand )
        {
        case EAknSoftkeyExit:
        case EEikCmdExit:
            {
            Exit();
            break;
            }
        // Send a new message
        case ESMSExampleCmdSendMessage:
            {
            // Ask recipient from the user. Return if Cancel was pressed.
            if (!GetAddressL())
                {
                return;
                }

            // Query message body. Return if Cancel was pressed.
            if (!QueryMessageL())
                {
                return;
                }

            iLogView->LogEventBeginningL();

            iSmsEngine->SendSmsL(iAddress, iMessage);

            break;
            }

        //MOVE MESSAGES
        case ESMSExampleCmdMoveMessageFromInboxToDrafts:
            {
            QueryMessagesAndExecuteL( ESMSExampleMove, KInbox, KDrafts );
            break;
            }
        case ESMSExampleCmdMoveMessageFromInboxToOutbox:
            {
            QueryMessagesAndExecuteL( ESMSExampleMove, KInbox, KOutbox );
            break;
            }
        case ESMSExampleCmdMoveMessageFromDraftsToInbox:
            {
            QueryMessagesAndExecuteL( ESMSExampleMove, KDrafts, KInbox );
            break;
            }
        case ESMSExampleCmdMoveMessageFromDraftsToOutbox:
            {
            QueryMessagesAndExecuteL( ESMSExampleMove, KDrafts, KOutbox );
            break;
            }
        case ESMSExampleCmdMoveMessageFromOutboxToInbox:
            {
            QueryMessagesAndExecuteL( ESMSExampleMove, KOutbox, KInbox );
            break;
            }
        case ESMSExampleCmdMoveMessageFromOutboxToDrafts:
            {
            QueryMessagesAndExecuteL( ESMSExampleMove, KOutbox, KDrafts );
            break;
            }

        //COPY MESSAGES
        case ESMSExampleCmdCopyMessageFromDraftsToInbox:
            {
            QueryMessagesAndExecuteL( ESMSExampleModeCopy, KDrafts, KInbox );
            break;
            }
        case ESMSExampleCmdCopyMessageFromDraftsToOutbox:
            {
            QueryMessagesAndExecuteL( ESMSExampleModeCopy, KDrafts, KOutbox );
            break;
            }
        case ESMSExampleCmdCopyMessageFromInboxToOutbox:
            {
            QueryMessagesAndExecuteL( ESMSExampleModeCopy, KInbox, KOutbox );
            break;
            }
        case ESMSExampleCmdCopyMessageFromInboxToDrafts:
            {
            QueryMessagesAndExecuteL( ESMSExampleModeCopy, KInbox, KDrafts );
            break;
            }
        case ESMSExampleCmdCopyMessageFromOutboxToInbox:
            {
            QueryMessagesAndExecuteL( ESMSExampleModeCopy, KOutbox, KInbox );
            break;
            }
        case ESMSExampleCmdCopyMessageFromOutboxToDrafts:
            {
            QueryMessagesAndExecuteL( ESMSExampleModeCopy, KOutbox, KDrafts );
            break;
            }

        // DELETE MESSAGE COMMANDS. Target folder is not needed.
        case ESMSExampleCmdDeleteMessageFromDrafts:
            {
            QueryMessagesAndExecuteL( ESMSExampleDelete, KDrafts, 0 );
            break;
            }
        case ESMSExampleCmdDeleteMessageFromOutbox:
            {
            QueryMessagesAndExecuteL( ESMSExampleDelete, KOutbox, 0 );
            break;
            }
        case ESMSExampleCmdDeleteMessageFromInbox:
            {
            QueryMessagesAndExecuteL(ESMSExampleDelete, KInbox, 0 );
            break;
            }

        // SETTINGS
        case ESMSExampleListBoxSetAutomaticDeleteOn:
            {
            CAknQueryDialog* conf = CAknQueryDialog::NewL(
                                            CAknQueryDialog::EWarningTone );

            TInt retCode =
            conf->ExecuteLD(R_AUTOMATIC_DELETE_CONFIRMATION_QUERY_DIALOG);

            if ( retCode )
                {
                iLogView->LogEventBeginningL();
                iLogView->DrawTextL( KAutomaticDeleteActivatedText );
                iSmsEngine->SetAutomaticDeletetion(ETrue);
                }
            break;
            }
        case ESMSExampleListBoxSetAutomaticDeleteOff:
            {
            iLogView->LogEventBeginningL();
            iLogView->DrawTextL( KAutomaticDeleteDeActivatedText );
            iSmsEngine->SetAutomaticDeletetion(EFalse);
            break;
            }

        default:
            break;
        }
    }

// Set ListBox mode and set folders. Operation is executed when the
// ActivateLocalView activates ListBox.
void CSMSExampleAppUi::QueryMessagesAndExecuteL(TInt aMode,
                                               TMsvId aOriginFolderID,
                                               TMsvId aDestinationFolderID)
    {
    iListboxView->SetListBoxMode( aMode );
    iListboxView->SetFolderID( aOriginFolderID );
    iListboxView->SetTargetFolderID( aDestinationFolderID );

    // Change to another view, function takes id of the view as a parameter
    // (ActivateLocalViewL  (  TUid  aViewId   ) ).
    // enum TMultiViewsViewNumber in SMSExample.hrh
    //defines these ids.
    ActivateLocalViewL(TUid::Uid(EListboxViewId));
    }


void CSMSExampleAppUi::ShowErrorL(TInt aErrorCode) const
    {
    _LIT(KErrMsg,"Error occured:");
    TBuf<KErrMsgLength> errorMsg (KErrMsg);
    errorMsg.AppendNum(aErrorCode);
    ShowMessageL(errorMsg);
    }

void CSMSExampleAppUi::ShowMessageL(const TDesC& aMsg) const
    {
    CAknGlobalNote* note = CAknGlobalNote::NewLC();
    note->ShowNoteL(EAknGlobalConfirmationNote,  aMsg);
    CleanupStack::PopAndDestroy(note);
    }

void CSMSExampleAppUi::HandleResourceChangeL(TInt aType)
    {
    CAknAppUi::HandleResourceChangeL(aType); //call to upper class

    // ADDED FOR SCALABLE UI SUPPORT
    // *****************************
    if ( aType == KEikDynamicLayoutVariantSwitch )
        {
        //do re-layout
        if( iLogView )
            iLogView->SizeChanged();
        if( iListboxView )
            iListboxView->SizeChanged();
        }
    //Must not call this if the components are on the control stack
    //iListboxView->HandleResourceChangeL(aType);
    //iLogView->HandleResourceChangeL(aType);
    }

void CSMSExampleAppUi::SendingMessage()
    {
    TRAPD(err,iLogView->DrawTextL(KSendingMsgTxt));
    }

void CSMSExampleAppUi::MessageSent()
    {
    TRAPD(err,iLogView->DrawTextL( KMessageSentTxt ) );
    }

void CSMSExampleAppUi::MessageReceived(const TDesC& aAddress, const TDesC& aMessage)
    {
    TRAPD(err, HandleReceivedMessageL(aAddress, aMessage) );
    if( err )
        {
        TRAP(err, ShowErrorL(err) );
        }
    }

void CSMSExampleAppUi::SmsEngineInitialized()
    {
    TRAPD(err,iLogView->DrawTextL(KEngineInitializedTxt));
    }

void CSMSExampleAppUi::SmsEngineError(TInt aErrorCode)
    {
    //if there was some error sending the SMS
    //iLogView->DrawTextL( KCouldNotSendSMS );
    TBuf<KErrMsgLength> err = KErrText();
    err.AppendNum(aErrorCode);
    TRAPD(error,iLogView->DrawTextL(err));
    }

//only if automatic deletion is on
void CSMSExampleAppUi::MessageDeleted()
    {
    TRAPD(err,iLogView->LogEventBeginningL());
    TRAP(err,iLogView->DrawTextL( KAutomaticDeletedMesssageText ) );
    }

void CSMSExampleAppUi::HandleReceivedMessageL(const TDesC& aAddress, const TDesC& aMessage)
    {
    if (aMessage.Length() > 0)
        {
        iLogView->DrawTextL( KMsgReceivedTxt );
        iLogView->DrawTextL( aAddress );

        TPtrC ptr = aMessage.Ptr();
        TBuf<KSmsMessageLength> number;

        // Try to find a number that has 10 or more digits
        // from message body and underline the found number.
        if ( iParser->ParseMessage( ptr, number ))
            {
            // Search number position in the message body
            TInt pos = aMessage.Find( number );

            iLogView->DrawTextWithoutCarriageL(
                                      aMessage.Left(pos)
                                      );

            iLogView->DrawUnderlinedTextL( aMessage.Mid(pos, number.Length()) );

            iLogView->DrawTextWithoutCarriageL(
                      aMessage.Right( aMessage.Length() - pos - number.Length() ));
            }
        else
            {
            iLogView->DrawTextL( aMessage );
            }
        }
    else
        {
        iLogView->DrawTextL( KNoBodyText );
        }
    }

// End of File
