/* ====================================================================
 * File: handlerAppView.h
 * Created: 09/27/05
 * Author: 
 * Copyright (c): , All rights reserved
 * ==================================================================== */

#ifndef __HANDLER_APPVIEW_H__
#define __HANDLER_APPVIEW_H__


#include <coecntrl.h>
#include "Common.h"

/*! 
  @class CHandlerAppView
  
  @discussion An instance of the Application View object for the handler 
  example application
  */
class CHandlerAppView : public CCoeControl
    {
public:

/*!
  @function NewL
   
  @discussion Create a CHandlerAppView object, which will draw itself to aRect
  @param aRect the rectangle this view will be drawn to
  @result a pointer to the created instance of CHandlerAppView
  */
    static CHandlerAppView* NewL(const TRect& aRect);

/*!
  @function NewLC
   
  @discussion Create a CHandlerAppView object, which will draw itself to aRect
  @param aRect the rectangle this view will be drawn to
  @result a pointer to the created instance of CHandlerAppView
  */
    static CHandlerAppView* NewLC(const TRect& aRect);


/*!
  @function ~CHandlerAppView
  
  @discussion Destroy the object and release all memory objects
  */
     ~CHandlerAppView();


public:  // from CCoeControl
/*!
  @function Draw
  
  @discussion Draw this CHandlerAppView to the screen
  @param aRect the rectangle of this view that needs updating
  */
    void Draw(const TRect& aRect) const;

public:

    void SetFileData(TFileName& aFileName, TDes8& aData);  

private:

/*!
  @function ConstructL
  
  @discussion  Perform the second phase construction of a CHandlerAppView object
  @param aRect the rectangle this view will be drawn to
  */
    void ConstructL(const TRect& aRect);

/*!
  @function CHandlerAppView
  
  @discussion Perform the first phase of two phase construction 
  */
    CHandlerAppView();
    
    void SizeChanged();

private:
    
    TFileName iName;
    TBuf<KTextLengthToRead> iData;    
    
    };


#endif // __HANDLER_APPVIEW_H__
