/* ====================================================================
 * File: handlerAppView.cpp
 * Created  : 27/06/06 by Forum Nokia
 * Author:
 * Copyright (c): , All rights reserved
 * ==================================================================== */

#include <coemain.h>
#include <eikenv.h>
#include <eikappui.h>
#include <eikapp.h>

#include "handlerAppView.h"
#include "handlerDocument.h"

const TInt KCharsToShowFromEnd = 10;

CHandlerAppView* CHandlerAppView::NewL(const TRect& aRect)
    {
    CHandlerAppView* self = CHandlerAppView::NewLC(aRect);
    CleanupStack::Pop(self);
    return self;
    }

CHandlerAppView* CHandlerAppView::NewLC(const TRect& aRect)
    {
    CHandlerAppView* self = new (ELeave) CHandlerAppView;
    CleanupStack::PushL(self);
    self->ConstructL(aRect);
    return self;
    }

CHandlerAppView::CHandlerAppView()
    {
    // no implementation required
    }

CHandlerAppView::~CHandlerAppView()
    {
    // no implementation required
    }

void CHandlerAppView::ConstructL(const TRect& aRect)
    {
    // Create a window for this application view
    CreateWindowL();

    // Set the windows size
    SetRect(aRect);

    // Activate the window, which makes it ready to be drawn
    ActivateL();
    }

// Draw this application's view to the screen
void CHandlerAppView::Draw(const TRect& /*aRect*/) const
    {
    // Get the standard graphics context
    CWindowGc& gc = SystemGc();

    // Gets the control's extent
    TRect rect = Rect();

    // Clears the screen
    gc.Clear(rect);

    const CFont* normalFont = CEikonEnv::Static()->NormalFont();
    gc.UseFont( normalFont );

    //get some characters from file path end and show them.
    TBuf<KCharsToShowFromEnd> endText = KNullDesC();
    endText.Zero();
    if( iName.Length() > KCharsToShowFromEnd-2 )
        {
        endText = iName.Right(KCharsToShowFromEnd-1);
        }

    const TPoint KPoint1 = TPoint(1,41);
    const TPoint KPoint2 = TPoint(1,21);
    const TPoint KPoint3 = TPoint(1,61);

    gc.DrawText(iName, KPoint1 );
    gc.DrawText(endText, KPoint2 );
    gc.DrawText(iData, KPoint3 );
    }

void CHandlerAppView::SizeChanged()
    {
    DrawDeferred();
    }

void CHandlerAppView::SetFileData(TFileName& aFileName, TDes8& aData)
    {
    iName = aFileName;
    iData.Copy( aData );
    DrawDeferred();
    }
