/* ====================================================================
 * File: handlerDocument.cpp
 * Created: 09/27/05
 * Author:
 * Copyright (c): , All rights reserved
 * ==================================================================== */

#include "handlerAppUi.h"
#include "handlerDocument.h"
#include "Common.h"

#include <f32file.h>
#include <eikenv.h>
#include <eikappui.h>
#include <eikapp.h>
#include <apparc.h>
#include <eikproc.H>
#include <apgwgnam.h> //Link against: apgrfx.lib
#include <avkon.hrh>
#include <aknnotewrappers.h>

CHandlerDocument* CHandlerDocument::NewL(CEikApplication& aApp)
    {
    CHandlerDocument* self = NewLC(aApp);
    CleanupStack::Pop(self);
    return self;
    }

CHandlerDocument* CHandlerDocument::NewLC(CEikApplication& aApp)
    {
    CHandlerDocument* self = new (ELeave) CHandlerDocument(aApp);
    CleanupStack::PushL(self);
    self->ConstructL();
    return self;
    }

void CHandlerDocument::ConstructL()
    {
    // no implementation required
    }

CHandlerDocument::CHandlerDocument(CEikApplication& aApp) : CAknDocument(aApp)
    {
    // no implementation required
    }

CHandlerDocument::~CHandlerDocument()
    {
    // no implementation required
    }

CEikAppUi* CHandlerDocument::CreateAppUiL()
    {
    // Create the application user interface, and return a pointer to it,
    // the framework takes ownership of this object
    iAppUi = new (ELeave) CHandlerAppUi;
    return iAppUi;
    }

CFileStore* CHandlerDocument::OpenFileL( TBool aDoOpen, const TDesC& aFilename, RFs& aFs )
    {
    if (aDoOpen)
        {
        TFileName name = aFilename;
        if( iFileName == name ) //The same file, do nothing
            {
            return NULL;   
            }
        iFileName = name;
        CHandlerAppUi *appui = static_cast<CHandlerAppUi *> (iAppUi);
        TBuf8<KTextLengthToRead> buf;

        RFile file;
        
        TInt err = file.Open(aFs, aFilename, EFileRead|EFileShareAny); 
        if( err == KErrNone )
            {
            CleanupClosePushL(file);
            User::LeaveIfError( file.Read(buf,KTextLengthToRead) );
            CleanupStack::PopAndDestroy();//file
            }
        appui->SetFileData(iFileName, buf);
        }
    
    return NULL;
    }

void CHandlerDocument::OpenFileL(CFileStore*& aFileStore, RFile& aFile)
    {
    aFileStore = NULL; //So the other OpenFileL version is not called

    TFileName name;
    #ifdef __SERIES60_3X__
        aFile.Name(name);
        //aFile.FullName(name); //If the location is required
    #endif
    //This function is never used in 1st or 2nd edition,
    //so the RFile::Name function is always executed.
    //That way we know that name variable contains aFile name.
    if( iFileName == name)
        {
        return;
        }
    iFileName = name;
    
    TBuf8<KTextLengthToRead> buf;
    User::LeaveIfError( aFile.Read(buf,KTextLengthToRead) );
    CHandlerAppUi *appui = static_cast<CHandlerAppUi *> (iAppUi);
    appui->SetFileData(iFileName, buf);
    }
