/* ====================================================================
 * File: TestAppAppView.h
 * Created: 28/06/06 by Forum Nokia
 * Author: 
 * Copyright (c): , All rights reserved
 * ==================================================================== */

#ifndef __TESTAPP_APPVIEW_H__
#define __TESTAPP_APPVIEW_H__


#include <coecntrl.h>

/*! 
  @class CTestAppAppView
  
  @discussion An instance of the Application View object for the TestApp 
  example application
  */
class CTestAppAppView : public CCoeControl
    {
public:

/*!
  @function NewL
   
  @discussion Create a CTestAppAppView object, which will draw itself to aRect
  @param aRect the rectangle this view will be drawn to
  @result a pointer to the created instance of CTestAppAppView
  */
    static CTestAppAppView* NewL(const TRect& aRect);

/*!
  @function NewLC
   
  @discussion Create a CTestAppAppView object, which will draw itself to aRect
  @param aRect the rectangle this view will be drawn to
  @result a pointer to the created instance of CTestAppAppView
  */
    static CTestAppAppView* NewLC(const TRect& aRect);


/*!
  @function ~CTestAppAppView
  
  @discussion Destroy the object and release all memory objects
  */
     ~CTestAppAppView();


public:  // from CCoeControl
/*!
  @function Draw
  
  @discussion Draw this CTestAppAppView to the screen
  @param aRect the rectangle of this view that needs updating
  */
    void Draw(const TRect& aRect) const;
  

private:

/*!
  @function ConstructL
  
  @discussion  Perform the second phase construction of a CTestAppAppView object
  @param aRect the rectangle this view will be drawn to
  */
    void ConstructL(const TRect& aRect);

/*!
  @function CTestAppAppView
  
  @discussion Perform the first phase of two phase construction 
  */
    CTestAppAppView();
    };


#endif // __TESTAPP_APPVIEW_H__
