/* ====================================================================
 * File: TestAppDocument.h
 * Created  : 27/06/06 by Forum Nokia
 * Author:
 * Copyright (c): , All rights reserved
 * ==================================================================== */

#ifndef __TESTAPP_DOCUMENT_H__
#define __TESTAPP_DOCUMENT_H__

#include <akndoc.h>

// Forward declarations
class CTestAppAppUi;
class CEikApplication;

/*!
  @class CTestAppDocument

  @discussion An instance of class CTestAppDocument is the Document part of the AVKON
  application framework for the TestApp example application
  */
class CTestAppDocument : public CAknDocument
    {
public:

/*!
  @function NewL

  @discussion Construct a CTestAppDocument for the AVKON application aApp
  using two phase construction, and return a pointer to the created object
  @param aApp application creating this document
  @result a pointer to the created instance of CTestAppDocument
  */
    static CTestAppDocument* NewL(CEikApplication& aApp);

/*!
  @function NewLC

  @discussion Construct a CTestAppDocument for the AVKON application aApp
  using two phase construction, and return a pointer to the created object
  @param aApp application creating this document
  @result a pointer to the created instance of CTestAppDocument
  */
    static CTestAppDocument* NewLC(CEikApplication& aApp);

/*!
  @function ~CTestAppDocument

  @discussion Destroy the object and release all memory objects
  */
    ~CTestAppDocument();

public: // from CAknDocument
/*!
  @function CreateAppUiL

  @discussion Create a CTestAppAppUi object and return a pointer to it
  @result a pointer to the created instance of the AppUi created
  */
    CEikAppUi* CreateAppUiL();

private:

/*!
  @function ConstructL

  @discussion Perform the second phase construction of a CTestAppDocument object
  */
    void ConstructL();

/*!
  @function CTestAppDocument

  @discussion Perform the first phase of two phase construction
  @param aApp application creating this document
  */
    CTestAppDocument(CEikApplication& aApp);

    };


#endif // __TESTAPP_DOCUMENT_H__
