/* ====================================================================
 * File: TestAppAppView.cpp
 * Created: 28/06/06 by Forum Nokia
 * Author: 
 * Copyright (c): , All rights reserved
 * ==================================================================== */

#include <coemain.h>
#include <TestApp.rsg>

#include "TestAppAppView.h"

// Standard construction sequence
CTestAppAppView* CTestAppAppView::NewL(const TRect& aRect)
    {
    CTestAppAppView* self = CTestAppAppView::NewLC(aRect);
    CleanupStack::Pop(self);
    return self;
    }

CTestAppAppView* CTestAppAppView::NewLC(const TRect& aRect)
    {
    CTestAppAppView* self = new (ELeave) CTestAppAppView;
    CleanupStack::PushL(self);
    self->ConstructL(aRect);
    return self;
    }

CTestAppAppView::CTestAppAppView()
    {
	// no implementation required
    }

CTestAppAppView::~CTestAppAppView()
    {
	// no implementation required
    }

void CTestAppAppView::ConstructL(const TRect& aRect)
    {
    // Create a window for this application view
    CreateWindowL();

    // Set the windows size
    SetRect(aRect);

    // Activate the window, which makes it ready to be drawn
    ActivateL();
    }

// Draw this application's view to the screen
void CTestAppAppView::Draw(const TRect& /*aRect*/) const
    {
    // Get the standard graphics context 
    CWindowGc& gc = SystemGc();
    
    // Gets the control's extent
    TRect rect = Rect();
    
    // Clears the screen
    gc.Clear(rect);
    }


