/** 
 *  @file MsgQInternal.h
 *  Description: Internal Header file for MsgQLib
 *  Copyright (c) 2007 Nokia Corporation.
 *  This material, including documentation and any related
 *  computer programs, is protected by copyright controlled by
 *  Nokia Corporation.
 */

#ifndef MSGQINTERNAL_H
#define MSGQINTERNAL_H

#include "MsgQLib.h"

/* data strucure used for maintaining message queues */

typedef struct MsgQInfo* MSGQ_INFO_PTR;

typedef struct MsgQInfo {
	MSGQ_INFO_PTR	 next;	      /* next entry in list                  */
	ULONG			 qName;       /* queue name                          */
	int				 qId;		  /* queue id                 			 */
	int				 semId ;      /* semaphore id           			 */
	ULONG			 sendState;	  /* message can be sent                 */
	ULONG			 numMsgs;     /* number of messages queued           */
	ULONG			 maxNumMsgs;  /* maximum number of messages queued   */
	struct msqid_ds* slMqInfo_p;  /* msg q info                  		 */
}MSGQ_INFO;


/* Linked List used for maintaining list of all message queues created */

typedef struct MsgQInfoList* MSGQ_INFO_LIST_PTR;

typedef struct MsgQInfoList {
	MSGQ_INFO_LIST_PTR next;     /* next entry in list */
	ULONG               qName;   /* queue name         */
} MSGQ_INFO_LIST;

/* Forward Declaration of Internal Functions */
int   InstallMsqQTable(ULONG qName, int qId, int semId, int* err);
void  AddToMsgQTable(ULONG qName);
int   RemoveFromMsqQTable(ULONG qName, int* err);
void  DeleteFromMsgQTable(ULONG qName);
MSGQ_INFO* MsgQTableLookup(ULONG qName);

#endif /* MSGQINTERNAL_H */
