/** 
 *  @file MsgQClean.cpp
 *  Description: Source file for MsgQLib's MsgQClean API
 *  Copyright (c) 2007 Nokia Corporation.
 *  This material, including documentation and any related
 *  computer programs, is protected by copyright controlled by
 *  Nokia Corporation.
 */

#include <errno.h>
#include <sys/msg.h>
#include "MsgQInternal.h"


/****************************************************************************
* MsgQClean (qName, err)
* Description: Function that empties the specified queue
*****************************************************************************/

EXPORT_C int MsgQClean(ULONG qName, int* err) {
	MSGQ_INFO* pMsgQInfo = NULL;
	char msg[MAX_MSG_LEN];
	int rcv_err;

	if ((pMsgQInfo = MsgQTableLookup(qName)) != NULL) {
		// sending a message is not allowed
		pMsgQInfo->sendState = MSG_Q_CLEANING;
		// empty out the queue 
		while(MsgQReceive(qName, msg, MAX_MSG_LEN, IPC_NOWAIT, &rcv_err) != ERROR) {};
		if (rcv_err == ENOMSG) {
			*err = OK;
			return (OK);
		}
		else
			*err = rcv_err;
		// sending a message is allowed
		pMsgQInfo->sendState = MSG_Q_READY;
	}
	else
		*err = KMsgQLibQIdErr;

	return(ERROR);
}


