/** 
 *  @file MsgQDelete.cpp
 *  Description: Source file for MsgQLib's MsgQDelete API
 *  Copyright (c) 2007 Nokia Corporation.
 *  This material, including documentation and any related
 *  computer programs, is protected by copyright controlled by
 *  Nokia Corporation.
 */

#include <errno.h>
#include <sys/msg.h>
#include <sys/sem.h>
#include "MsgQInternal.h"


/*******************************************************************************
* MsgQDelete (qName, err)
* Description: Function for deleting a message queue
********************************************************************************/

EXPORT_C int MsgQDelete(ULONG qName, int* err)
{
	MSGQ_INFO*		 pMsgQInfo;
	int              hashRmErr;

	if ((pMsgQInfo = MsgQTableLookup(qName)) != NULL) {
		if (semctl(pMsgQInfo->semId,0,IPC_RMID,0) == 0) {
			if (msgctl(pMsgQInfo->qId,IPC_RMID,0) == 0) {
				if (RemoveFromMsqQTable(pMsgQInfo->qName, &hashRmErr) == OK) {
					DeleteFromMsgQTable(qName);
					*err = OK;
					return (OK);
				}
				else
					*err = hashRmErr;
			}
			else 
				*err = errno;
		}
		else
			*err = errno;
	}
	else
		*err = KMsgQLibQIdErr;

	return(ERROR);
}

