/** 
 *  @file MsgQRecv.cpp
 *  Description: Source file for MsgQLib's MsgQReceive API
 *  Copyright (c) 2007 Nokia Corporation.
 *  This material, including documentation and any related
 *  computer programs, is protected by copyright controlled by
 *  Nokia Corporation.
 */

#include <errno.h>
#include <sys/msg.h>
#include <sys/sem.h>
#include <unistd.h>
#include <string.h>
#include "MsgQInternal.h"



/*******************************************************************************
* MsgQReceive (qName, msg, maxNBytes, timeout, err)
* Description: Function for receiving a message with internal copy
********************************************************************************/

EXPORT_C int MsgQReceive(ULONG qName, char* msg, ULONG maxNBytes, int timeout, int* err) {
	MSGQ_INFO* pMsgQInfo = NULL;
	ssize_t rxBytes;
	int toTicks;

	struct {
		long  mtype;
		char mtext[MAX_MSG_LEN];
	} message;

	/* check parameters */
	if ((pMsgQInfo = MsgQTableLookup(qName)) != NULL) {
		if(timeout != NO_WAIT && timeout != WAIT_FOREVER)
			toTicks = timeout < 10 ? 1: (ULONG)((timeout * sysconf(_SC_CLK_TCK)) / 1000);
		else
			toTicks = timeout;      

		message.mtype = 1;
		/* receive message */
		if((rxBytes = msgrcv(pMsgQInfo->qId, &message, (size_t)maxNBytes, 1, toTicks)) != -1) {
			message.mtext[rxBytes-4] = '\0';
			bcopy(message.mtext, msg, rxBytes);
			pMsgQInfo->numMsgs--;
			*err = OK;
			return ((ULONG)rxBytes);
		}
		else
			*err = errno;
	}
	else
		*err = KMsgQLibQIdErr;

	return(ERROR);
}


