/** 
 *  @file MsgQSend.cpp
 *  Description: Source file for MsgQLib's MsgQSend API
 *  Copyright (c) 2007 Nokia Corporation.
 *  This material, including documentation and any related
 *  computer programs, is protected by copyright controlled by
 *  Nokia Corporation.
 */

#include <errno.h>
#include <sys/msg.h>
#include <sys/sem.h>
#include <string.h>
#include "MsgQInternal.h"


/*******************************************************************************
* MsgQSend (qName, msg, nBytes, priority, timeout, err)
* Description:  Function for sending a message with internal copy
*********************************************************************************/

EXPORT_C int MsgQSend(ULONG qName, char* msg, ULONG nBytes, ULONG priority, int timeout, int* err)
{
	MSGQ_INFO* pMsgQInfo = NULL;

	struct {
		long mtype;
		char mtext[MAX_MSG_LEN];
	} message;

	/* structure used for semaphore post operation */
	struct sembuf op;
	
	/* init the  semop () structure which is used for wait and signal operations */
	op.sem_num = 0;
	op.sem_op = -1;
	op.sem_flg = SEM_UNDO;

	/* check parameters */
	if ((priority == MSG_PRI_NORMAL) || (priority == MSG_PRI_URGENT)) {
		if((pMsgQInfo = MsgQTableLookup(qName)) != NULL) {
			if (pMsgQInfo->sendState == MSG_Q_READY) {
				op.sem_flg = op.sem_flg | timeout;
				if((semop(pMsgQInfo->semId, &op, 1)) == OK) {
					pMsgQInfo->numMsgs++;
					if(pMsgQInfo->maxNumMsgs < pMsgQInfo->numMsgs)          
					pMsgQInfo->maxNumMsgs = pMsgQInfo->numMsgs;

					message.mtype = 1;
					bcopy(msg, message.mtext, nBytes);
					message.mtext[nBytes] = '\0';

					if(msgsnd (pMsgQInfo->qId, &message, (size_t)nBytes+4, timeout) == OK) {
						*err = OK;
						/* After successfull send, unlock the message queue by using post operation on semaphore.*/
						op.sem_op = 1;
						semop(pMsgQInfo->semId, &op, 1);
						return (OK);
					}
					else {
						*err = errno;
						pMsgQInfo->numMsgs--;
						op.sem_op = 1;
						semop(pMsgQInfo->semId, &op, 1);
					}
				}
				else
					*err = errno;
			}
			else
				*err = KMsgQLibQFlushErr;
		}
		else
			*err = KMsgQLibQIdErr;
	}
	else
		*err = KMsgQLibParamErr;

	return(ERROR);
}


