/** 
 *  @file MsgQClient.c
 *  Description: A multithread program used for Testing MsgQLib library.
 *  This application will create 2 message queues and creates 2 threads
 *  passing them the queue id. These threads will send and receive messages
 *  to each other.
 *  Copyright (c) 2007 Nokia Corporation.
 *  This material, including documentation and any related
 *  computer programs, is protected by copyright controlled by
 *  Nokia Corporation.
 */


# include <pthread.h>
# include <stdio.h>
# include <string.h>
# include <unistd.h>
//# include <staticlibinit_gcce.h>
# include "MsgQLib.h"

ULONG q1 = 1;
ULONG q2 = 2;
const int KMaxMsg = 10;

/**
 Entry point for threads
 This will send message to one queue and wait for some messages from other queue
*/
void ThreadFunction(int *id) {
	int i = 2;
	int err = 0;
	int result = 0;
	int pri = MSG_PRI_NORMAL;
	int timeout = NO_WAIT;
	int len = 100;
	int nBytes;
	char smsg[] =  "Sending Some Data through MsgQ";
	char rmsg[100];
	ULONG queueOne = q1;
	ULONG queueTwo = q2;
	
	//If 2nd Thread
	if(*id == q2) {
		queueOne = q2;
		queueTwo = q1;
		}

	printf("Thread %d: Started..\n", *id);

	/* Try to Create queueOne again, this will create the queue again,
	   this will just return as its already created by main thread */
	result = MsgQCreate(queueOne, KMaxMsg, MSG_Q_FIFO, &err);
	printf("Thread %d: Q CREATE result = %d\n", *id, result);

	while(i>=0) {
	
		nBytes = strlen(smsg); 
		/* Send Message to queueOne */
		result = MsgQSend(queueOne, smsg, nBytes, pri, timeout, &err); 
		printf("Thread %d: Q SEND result = %d\n", *id, result);

		sleep(1);
		rmsg[0] = '\0';
		/* Receive Message from queueTwo */
		result = MsgQReceive(queueTwo, rmsg, len, timeout, &err); 
		rmsg[result] = '\0';
		printf("Thread %d: Q RECEIVE result = %d\n", *id, result);
		printf("Thread %d: Message Received from Message Queue 2 is : %s\n", *id, rmsg);
		i--;
	}
	sleep(2);
	
	/* delete message queueOne */
	result=MsgQDelete(queueOne, &err);
	printf("Thread %d: Q DELETE result = %d\n", *id, result);
}


int main() {
	int result;
	int err;
	pthread_t thread1;
	pthread_t thread2;

	printf("Main Thread: Started..\n");

	/* Create 2 Message Queues */
	result = MsgQCreate(q1, KMaxMsg, MSG_Q_FIFO, &err);
	printf("Main Thread: Q CREATE result = %d\n",result);

	result = MsgQCreate(q2, KMaxMsg, MSG_Q_FIFO, &err);
	printf("Main Thread: Q CREATE result = %d\n",result);


	/* Create 2 Threads */
	if(pthread_create(&thread1, NULL, (thread_begin_routine)ThreadFunction, (void*) &q1) != 0) {
		printf("Main Thread: Failed to create the threadOne\n");
	}

	if(pthread_create(&thread2, NULL, (thread_begin_routine)ThreadFunction, (void*) &q2) != 0) {
		printf("Main Thread: Failed to create the threadTwo\n");
	}

	/* Wait for the threads to complete */
	pthread_join(thread1, NULL);
	pthread_join(thread2, NULL);
	printf("Main Thread: Exiting from Main() \nMain Thread: Enter a Key to Exit");
	getchar();
	return 0;
}
