/*
* ==============================================================================
*  Name        : example.cpp
*  Part of     : OpenCStringUtilitiesExeEx
*  Interface   : 
*  Description : 
*  Version     : 
*
*  Copyright (c) 2005-2007 Nokia Corporation.
*  This material, including documentation and any related 
*  computer programs, is protected by copyright controlled by 
*  Nokia Corporation.
* ==============================================================================
*/
#ifdef __GCCE__
//#include <staticlibinit_gcce.h>
#endif

#include "example.h"

// Constant strings
_LIT( KSampleWideString, "Sample Wide String" );
_LIT8( KSampleNarrowString, "Sample Narrow String" );

void testTbuf16()
{
	// Tbuf16 Conversions
	TBuf16<SIZE> buf(KSampleWideString);
	
	wchar_t* ws = tbuf16towchar(buf);

	printf("After tbuf16towchar.........\n");
	wprintf(L"Result string: %ls\n", ws);	
	GETCHAR();

	//Should allocate space for the destination
	char nar_str[SIZE] = "\0";
	int retVal = tbuf16tochar(buf ,nar_str);

	if ( retVal == -1 )
	{
		printf(" tbuf16tochar failed..........\n");
		GETCHAR();
		return;
	}
	
	printf(" After tbuf16tochar..........\n");
	printf("\nResult string: %s\n", nar_str );	
	GETCHAR();
}

void testTbuf8()
{		
	// TBuf8 Conversions
		TBuf8<SIZE> buf2((TText8*)"Hello World");
		char *ns = (char*)tbuf8tochar(buf2);

	printf("After tbuf8tochar.........\n");
	printf("Result string: %s\n", ns);	
	GETCHAR();

	//Should allocate space for the destination
	wchar_t wstr[SIZE];
	TInt retVal = tbuf8towchar(buf2, wstr);
	if ( retVal == -1 )
	{
		printf("tbuf8towchar failed..........\n");
		GETCHAR();
		return;
	}

	printf("After tbuf8tochar.........\n");
	wprintf(L"Result string: %ls\n", wstr);	
	GETCHAR();
}

void testTbufC8()
{
	// TBufC8 Conversions
	wchar_t wstr[SIZE];
	TBufC8<SIZE> bufc8((TText8*)"Sample String");
	int retVal = tbufC8towchar(bufc8 ,wstr);
	if ( retVal == -1 )
	{
		printf("tbufC8towchar failed..........\n");
		GETCHAR();
		return;
	}
	printf(" After tbufC8towchar.........\n");
	wprintf(L"Result string: %ls\n", wstr);	
	GETCHAR();

	char str[SIZE];
	tbufC8tochar(bufc8, str);

	printf(" After tbufc8tochar.........\n");
	printf("Result string: %s\n", str);	
	GETCHAR();
}

void testTbufC16()
	{
	// TBufC16 Conversions
	wchar_t wstr[SIZE];
	TBufC<SIZE> bufc(KSampleWideString);

	tbufC16towchar(bufc ,(wchar_t*)wstr);

	printf(" After tbufC16towchar.........\n");
	wprintf(L"Result string: %ls\n", wstr);	
	GETCHAR();

	char str[SIZE];
	int retVal = tbufC16tochar(bufc ,str);
	if ( retVal == -1 )
	{
		printf("tbufC16tochar failed..........\n");
		GETCHAR();
		return;
	}

	printf(" After tbufC16tochar.........\n");
	printf("Result string: %s\n", str);	
	GETCHAR();

}

void testHbufC16()
{
	// HBufC16 conversions
	HBufC16 *p = HBufC16::NewLC(SIZE);	
	TBuf16<SIZE> buf(KSampleWideString);
	*p = buf;

	wchar_t wptr[SIZE];

	hbufC16towchar(*p, wptr);

	printf("After hbufC16towchar.........\n");
	wprintf(L"Result string: %ls\n", wptr);
	GETCHAR();

	char char_ptr[SIZE];
	int retVal = hbufC16tochar(*p, char_ptr);

	if ( retVal == -1 )
	{
		printf("hbufC16tochar failed..........\n");
		GETCHAR();
		return;
	}

	printf("After hbufC16tochar.........\n");
	printf("Result string: %s\n", char_ptr);	
	GETCHAR();

	CleanupStack::PopAndDestroy(1);
}


void testHbufC8()
{
	//HBufC8 conversions
	HBufC8 *p8 = HBufC8::NewLC( 30 );	
	TBuf8<SIZE> buf8(KSampleNarrowString);
	*p8	=	buf8;

	wchar_t ptr[SIZE] = L"\0";
	int retVal = hbufC8towchar(*p8, ptr);

	if ( retVal == -1 )
	{
		printf("hbufC8towchar failed..........\n");
		GETCHAR();
		return;
	}

	printf("After hbufC8towchar.........\n");
	wprintf(L"Result string: %ls\n", ptr);	
	GETCHAR();

	char char_ptr[SIZE]= "\0";
	hbufC8tochar(*p8, char_ptr);

	printf("After hbufC8tochar.........\n");
	printf("Result string: %s\n", char_ptr);	
	GETCHAR();

	CleanupStack::PopAndDestroy(1);
}

void testWchar()
{
	// Wchar Conversions
	const wchar_t *wstr = L"Hi good morning";
	TBuf16<SIZE> buf;

	wchartotbuf16(wstr, buf);


	// Allocate mem for the Destination
	HBufC16 *p = HBufC16::NewLC(SIZE);	
	TBuf16<SIZE> tbuf (KSampleWideString);
	*p	=	tbuf;
	wchartohbufc16(wstr ,*p);


	TBuf8<SIZE> buf8(KSampleNarrowString);
	int retVal = wchartotbuf8(wstr,buf8);

	if ( retVal == -1 )
	{
		printf("wchartotbuf8 failed..........\n");
		GETCHAR();
		return;
	}


	HBufC8 *p_8 = HBufC8::NewLC(30);	
	TBuf8<SIZE> buf_8(KSampleNarrowString);
	*p_8	=	buf_8;
	int ret = wchartohbufc8(wstr ,*p_8);
	if ( retVal == -1 )
	{
		printf("wchartohbufc8 failed..........\n");
		GETCHAR();
		return;
	}
	CleanupStack::PopAndDestroy(2);	

}


void testChar() 
{
	// Char Conversions
	const char *str = "Hi_good morning!!";
	TBuf16<SIZE> buf(KSampleWideString);

	TInt retVal = chartotbuf16(str, buf);
	if ( retVal == -1 )
	{
		printf("chartotbuf16 failed..........\n");
		GETCHAR();
		return;
	}


	// Allocate mem for the Destination
	HBufC16 *p = HBufC16::NewLC(SIZE);	
	TBuf16<SIZE> tbuf(KSampleWideString);
	*p = tbuf;
	int ret = chartohbufc16(str, *p);
	if ( ret == -1 )
	{
		printf("chartohbufc16 failed..........\n");
		GETCHAR();
		return;
	}

	TBuf8<SIZE> buf8(KSampleNarrowString);
	chartotbuf8(str,buf8 );

	HBufC8 *p_8 = HBufC8::NewLC(SIZE);	
	TBuf8<SIZE> buf_8(KSampleNarrowString);
	*p_8 = buf_8;

	chartohbufc8( str,*p_8);

	CleanupStack::PopAndDestroy(2);	
}


int main() 
{
		// Tbuf16 Conversions
	testTbuf16();
	// Tbuf8 Conversions
	testTbuf8();

	// TbufC8 Conversions
	testTbufC8();

	// TBufC16 Conversions
	testTbufC16();

	// HBufC16 Conversions
	testHbufC16();	

	// HBufC8 Conversions
	testHbufC8();

	// Wchar conversions
	testWchar();

	// Char Conversions
	testChar();

	return 0;
}
