// Copyright (c) 2006-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains the CAsyncWaiter class.
//



/**
 @file
*/
#ifndef __ASYNCWAITER_H_
#define __ASYNCWAITER_H_

#include <e32base.h>

/**
CAsyncWaiter is a class that publicly inherits the class CActive.
CActive is core class of the active object abstraction.
It encapsulates both issuing a request to an asynchronous service provider 
and handling the completed requests.
*/
class CAsyncWaiter : public CActive
	{
public:
	static CAsyncWaiter* NewL();
	~CAsyncWaiter();

	void StartAndWait();
	TInt Result() const;
private:
	CAsyncWaiter();
	// CActive implementation
	virtual void RunL();
	virtual void DoCancel();
private:
	TInt iError;
	};
#endif // __ASYNCWAITER_H_
