// Copyright (c) 2006-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// CentRepExample .h
// Contains the CCentRepExample class.
//



/**
 @file
*/
#ifndef __CENTREPEXAMPLE_H__
#define __CENTREPEXAMPLE_H__

// Symbian platform includes
#include <centralrepository.h> 

/**
CCentRepExample demonstrates some uses of the CRepository class.
CRepository provides access to the Symbian platform central repository,
which is used to store system and application settings. 

The class demonstrates how to open a repository, read, write,
and delete settings, perform operations in a transaction, 
find settings, restore default settings, and request 
change notifications.
*/
class CCentRepExample :public CBase
	{
public:
	static CCentRepExample* NewLC();

	~CCentRepExample();
	void ResetL();
	void OpenRepositoryL();
	void RdChgSetL();
	void ReadSettingsL();
	void ChangeSettingsL();
	void MoveSettingsL();
	void ResetAndNotifyL();
	void FindSettingsL();
	void TransactionFuncL();
	void DeleteL();
	
private:
	CCentRepExample();
	void ConstructL();
private:
	/** Pointer to the console interface */
	CConsoleBase* 		iConsole;
	/** Pointer to the class that provides access to a repository. */
	CRepository* iRepository;
    };

#endif //__CENTREPEXAMPLE_H__
