// raiseSignal.c
//
// Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description: raiseSignal.c source file
//

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>

/**
 Wait for a key press.
*/

void PressKey()
    {
    int ch;
    printf("Press 'e'+Enter to exit\n");
    while((ch = getchar()) != 'e')
        {
        if(ch == '\n')
            continue;
        else
            printf("wrong option inserted, try again!!!\n");
        }
    }

/**
 Entry point for the raiseSignal process.
 The raiseSignal process obtains the PID of sigtermSignal, and sends the SIGTERM signal to it.
 */
int main(int argc,char **argv)
    {
    pid_t id;
    int ret;
    if(argc < 2)
        {
        printf("Please pass the correct arguments\n");
        return EXIT_FAILURE;
        }
    id = atoi(argv[1]);
	
    printf("*********************In the raiseSignal***********************\n");
    printf("\nThis process sends a SIGTERM signal to the sigtermSignal process.\n");
    printf("\nPress Enter to send the SIGTERM signal\n");
    getchar();
    
    //Raising SIGTERM signl using kill command.
    ret = kill(id, SIGTERM);
    if(ret)
        {
        printf("Kill() failed, errno=%d", errno);
        } 
    PressKey();
    return EXIT_SUCCESS;
    }
