// sigtermSignal.c
//
// Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description: The source code file for sigtermSignal.
//

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>
#include <e32def.h>
#include <time.h>
#include <spawn.h>

FILE *gfp = NULL;
char *testfile = "C:\\testfile.txt";

/**
 Waits for a key press.
 */
void PressKey()
    {
    int ch;
    printf("Press 'e'+Enter to exit\n");
    while((ch=getchar())!= 'e')
        {
        if(ch == '\n')
            continue;
        else
            printf("wrong option selected, please try again!!!\n");
        }
    }
/**
 Handler for a SIGTERM signal. This handler will close all the opened file descriptors and 
 gracefully terminate the process.
 If there is no custom handler for SIGTERM, the default handler will come into picture and it will 
 terminate the running process without closing the opened file descriptors.
 */
void SIGTERM_handler(int signum)
    {
    if(signum == SIGTERM)
        {
        if(gfp != NULL)
            {
            printf("Received the SIGTERM signal from the raiseSignal process\n");
            fclose(gfp);
            remove(testfile);
            gfp = NULL;
            printf("The open file descriptor was closed\n");
            PressKey();
            exit (0);
            }
        }
    }

/**
 The entry point for the example.
 This example demonstrates SIGTERM signal handling and graceful process termination.
 The main function opens a file for read and write, takes a number of names entered by the user,
 writes these names into  file, reads the names from the file (one at a time) and finally  
 displays them on the console. 
 
 If a SIGTERM signal is received, then the file is closed, the file is deleted and then the process exits.
**/
int main()
    {
    char input[11];   
    int count = 0,num;
    int ch,ret;
    pid_t usrProcsID;
    const int delay = 4;                                    //Time delay of 4 sec provided.
    const int size = 50;                                    //No.of characters allowed in the filename.
    const int index = 3;                                    //No.of elements in the array.
    
    char *usrProcess = "Z:\\sys\\bin\\raisesignal.exe";    //Filename of process used for raising SIGTERM signal.
    char **argv = (char**)malloc(index*sizeof(char*));      //Variable holding values to be passed on to the raiseSignal process. 
    argv[0] = (char*)malloc(size*sizeof(char));
    argv[1] = (char*)malloc(index*sizeof(char));
    argv[2] = NULL;

    
    strcpy(argv[0], "z:\\sys\\bin\\raisesignal.exe");       //argv[0] holding name of the child process.
    sprintf(argv[1],"%d",getpid());                         //argv[1] holding parent pid.

    printf("*****************************************************************************************\n");
    printf("* Welcome to the demonstration of a graceful process termination using a SIGTERM signal *\n");
    printf("*****************************************************************************************\n");
    
    printf("* This example shows how a SIGTERM signal can be used to gracefully terminate a process.\n");
    printf("* The example first creates a process called sigtermSignal, assigns a custom handler\nfor the SIGTERM signal, opens a file and gets names from the user to be written in to it.\n");
    printf("* It then simultaneously spawns a raiseSignal process and starts reading from the file.\n");
    printf("* The raiseSignal process sends a SIGTERM signal to the sigtermSignal process.\n");
    printf("* On receiving the SIGTERM signal, the sigtermSignal process closes all the \nopen file descriptors and prepares to exit.\n");
    
    printf("\nPress the Enter key to continue\n");
    getchar();

    signal(SIGTERM, SIGTERM_handler);
    printf("************ In the sigtermSignal process ************\n");
    printf("Enter the number of names you want to enter (e.g. 8) :\n");
    scanf("%d", &count);
    gfp=fopen(testfile, "w+");   //Opening the file for read and write.
    if(gfp != NULL)
        {
        printf("File open sucessful\n");
        }
    else
        {
        printf("File open failed\n");
        }
    for(num=1; num<=count; num++)
        {
        printf("Name (%d)=", num);
        scanf("%s", input);
        fprintf(gfp, "%s\n", input);
        }
    
    printf("Press the Enter key to spawn the raiseSignal process\n");
    getchar();
    getchar();
    //Spawning raiseSignal process to accept user input.
    ret = posix_spawn(&usrProcsID,usrProcess,NULL,NULL,argv,(char**)NULL);
    if(ret != 0)     
        {         
        printf("\n*** failure posix_spawn ***\n");        
        return EXIT_FAILURE;     
        }
     rewind(gfp);
     printf("Starting to read from the file\n");
     for(num=1; num<=count; num++)
         {
         sleep (delay);       
         printf("Name (%d)=", num);
         while((ch=(fgetc(gfp))) != '\n')
                  {
                  putchar(ch);
                  }
         printf("\n");
         
         }
    if(!fclose(gfp))
        {
        remove(testfile);
        gfp = NULL;
        printf("File closed successfully\n");
        }
    else
        {
        printf("File close failed\n");
        }
  
    PressKey();
    return EXIT_SUCCESS;
    }
