// Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#ifndef __PROCESSSERVERSESSION_H__
#define __PROCESSSERVERSESSION_H__

#include <e32base.h>
#include <e32std.h>
#include "processserver.h"


const TInt KMaxAsyncRequests = 4;
class CProcessServer;
/**
	Server-side client session class for process server
*/	
class CProcessServerSession : public CSession2
	{
public:
	static CProcessServerSession* NewL(CProcessServer& aServer);
	~CProcessServerSession();
	void CreateL();// Create a server-side client session
	void ServiceL(const RMessage2& aMessage);// Handles the client request
	
	
private:
	CProcessServerSession(CProcessServer& aServer);
	void ConstructL();
	
	// Active object class for asynchronous requests
	class CAsyncHandler : public CActive 
		{
	public:
		static CAsyncHandler* NewL(CProcessServer& aServer);
		~CAsyncHandler();
		
		 //Store async request in message array
		TInt ProcessRequest(const RMessage2& aMessage);
	private:

		CAsyncHandler(CProcessServer& aServer);
		void ConstructL();
		
		// CActive implementation
		void RunL();
		void DoCancel();
			
		TInt ExecuteFirstRequestInArray();// Execute messages in array
		
		/**
		Structure for holding a simple message
		*/
		class TMessage
			{
		public:
			const RMessage2& Message() const; 	// getter
			RMessage2& Message();				// setter
		private:
			RMessage2 iMessage;
			};
		
		void Complete(TInt aResult);
		
	private:
		RArray<TMessage>  		iMessageArray;
		CProcessServer& 		iServer;
		};
	
private:
	CProcessServer& iServer;
	CAsyncHandler* 	iAsyncRequestHandler;
	
	};

#endif
