// Copyright (c) 2000-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//


#ifndef __FILECHANGENOTIFIER_H__
#define __FILECHANGENOTIFIER_H__

#include <e32base.h>
#include <e32cons.h>
#include <f32file.h>
#include <f32notification.h>

/*
 * Demonstrates the various features of Enhanced File change notifier.
 * - User gets notified when there is a change in a File.
 * - User gets notified when there is a change in a Folder.
 * - User gets notified when there is a change in a Drive.
 */
class CChangeNotifier: public CActive
{
public:
    static CChangeNotifier* NewL(TInt aPriority = EPriorityStandard);
    virtual ~CChangeNotifier();
    void RequestCharacter(); 
protected:
    void ConstructL();

public:
    enum TFileOperations{
        ECreateFile,
        EChangeFileContents,
        ERenameFile,
        EChangeFileAttributes ,
        EDeleteFile,
        ECreateFolder,
        ERenameFolder,
        EDeleteFolder,
        EVolumeNameChange,
        EMultipleNotifications
        };
private: 
    virtual void DoCancel();
    virtual void RunL();
    void PressAnyKey();
    void NotifyChangeToFile(); // get notified when there is a change in the file.
    void NotifyChangeToFolder(); // get notified when there is a change in the folder.
    void CreateFile(); // get notified when a new file is created.
    void ChangeFileContents(); // get notified when the file contents are changed.
    void RenameFile(); // get notified when a file is renamed.
    void ChangeFileAttributes (); // get notified when the file attributes change.
    void DeleteFile(); // get notified when a file is deleted.
    void CreateFolder(); // get notified when a folder is created.
    void RenameFolder(); // get notified when a folder is renamed.
    void DeleteFolder(); // get notified when a folder is deleted.
    void DeleteFileandFolder(); // get notitified when a folder is deleted, file in the folder is also deleted.
    void VolumeNameChange(); // get notified when there is a volume name change.
    void MultipleNotifications(); // multiple notifications can be requested at once, completed notifications are filled in the buffer.
    void DoChanges(CChangeNotifier::TFileOperations operation); // Do file/folder changes.
    void ProcessMultipleChanges(const TFsNotification* aNotification); // Process the completion of multiple notifications requested by 'Multiple Notifications' use case.
    
private: 
    CChangeNotifier(TInt aPriority = EPriorityStandard );
    /*
     * These booleans are used to detect whether the file change operation was performed earlier or not.
     * Ex: If a folder is already created and the user tries to create it once again, it prints that the file is created.
     */
    TBool iIsCreateFolder; // to verify whether a folder is created or not.
    TBool iIsRenameFolder; // to verify whether the rename operation on a folder is performed already.
    TBool iIsDeleteFolder; // to verify whether the delete folder operation is performed already.
    TBool iIsVolumeNameChange; // to verify whether the volume name change operation is done already.
    TBool iIsCreateFile; // to verify whether the file is created in the desired location already.
    TBool iIsRenameFile; // to verify whether the rename operation on the file is performed already.
    TBool iIsChangeFileAttributes ; // to verify whether the file attributed are changed already.
    TBool iIsDeleteFile; // to verify whether the file is deleted already.
    TBool iDeleteFileContinue; // this boolean is used when a folder with a file needs to be removed. it removes the file and then calls folder removal.
    TBool iIsMultipleNotifications;
    RFs iFs;
    TChar iDrive; // System drive
    TInt iDriveNumber; // drive number of U: drive
    TBool iOption; // This boolean is used to exit, if none of the Main menu options is chosen.
    TBool iOptionContinue; // it is used to continue with the Main menu, if none of the sub menu options is chosen.
    CConsoleBase* iConsole;
    CFsNotify* iNotify; // This is client which will be posting notification requests and will be notified after completion of these requests.
    TRequestStatus iReqStatus;
};
#endif  // __CHANGENOTIFIER_H__


