// Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// shared client/server definitions.
//

#include <e32std.h>

#ifndef __THREAD_CLIENT_SERVER_H__
#define __THREAD_CLIENT_SERVER_H__

// Stores the size of the new thread's stack.
const TInt KThreadServerStackSize=0x2000;

// Stores the maximum length of the message where client data can be written. 
const TInt KThreadServerMaxMessageLen=100;

// Stores the minimum size of the new thread's heap.
const TInt KThreadServerInitHeapSize=0x1000;		//  4KB

// Store the maximum size of the new thread's heap. 
const TInt KThreadServerMaxHeapSize=0x1000000;		// 16MB

/**
	Enumeration for client requests that have been passed to the server.
*/
enum TThreadServerRequest
	{
	EThreadServerLoadDeviceDriver,
	EThreadServerUnloadDeviceDriver,
	EThreadServerOpenDriver,
	EThreadServerSendData,
	EThreadServerSendDataCancel
	};

_LIT(KThreadServerDriverLddFileName,"DRIVER1_LDD");
_LIT(KThreadServerDriverPddFileName,"DRIVER1_PDD");

_LIT(KThreadServerName,"ThreadServer");

_LIT(KThreadServerServerImg, "ThreadServer");

// Stores the major version number. This must be a number in the range 0 to 127.
const TUint KThreadServerVersion=8;

// Stores the minor version number. This must be a number in the range 0 to 99.
const TUint KThreadServerMinorVersionNumber=0;

// Stores the build number. This must be a number in the range 0 to 32,767.
const TUint KThreadServerBuildVersionNumber=1;

#endif //__THREAD_CLIENT_SERVER_H__
