// Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#ifndef __THREADSERVER_H__
#define __THREADSERVER_H__

#include <e32base.h>
#include <e32std.h>
#include "shutdownserver.h"
#include "threadclientserver.h"
#include "threadserverstart.h"
#include "driver1.h"

class CAsyncHandler; 

/**
	Server interface for thread server.
*/
class CThreadServer : public CServer2
	{
public:
	/**
	Enumeration of the driver states.
	*/
	enum TDriverState
		{
		EStateUnknown,
		EDriverLoaded,
		ELogicalChannelOpened,
		ESendingData,
		ELogicalChannelClosed,
		EDriverUnloaded
		};
	/**
	 Thread entry function.
	 */
	IMPORT_C static TInt StartThread(TAny* aPointer);
	/**
	 First and second phase constructor.
	 */
	static void NewLC();
	/**
	 Destructor.
	 The device driver will be unloaded when the server destructor is called.
	 */
	~CThreadServer();
	/**
	 Create a server-side session object.
	 @see CServer2::NewSessionL().
	 */
	CSession2* NewSessionL(const TVersion& aVersion,const RMessage2& aMessage) const;
	/**
	 Increase reference count and cancel shutdown timer.
	 This function is called when a new session is created.
	 */
	void IncrementRefCount();
	/**
	 Decrease reference count and start shutdown timer.
	 This function is called when a session is destroyed.
	 */
	void DecrementRefCount();
	/**
	 Load device, including sample PDD and LDD.
	 */
	TInt LoadDevice();
	/**
	 Unload device, including sample LDD and PDD.
	 */
	TInt UnloadDevice();
	/**
 	 Open device logical channel.
 	*/
	TInt OpenLogicalChannel();
	/**
 	 Close device logical channel.
 	*/
	void CloseLogicalChannel();
	/**
 	 Send data to device. It is an asynchronous request.
 	*/
	TInt SendDataToDevice(TRequestStatus& aStatus, const TDesC8& aData);
	/**
 	 Cancel send data operation to device driver.
 	*/
	void CancelSendData();
	/**
	 Update device state.
	 */
	void UpdateDriverState(TDriverState aState);
	
	
private:
	CThreadServer();
	void ConstructL();
	
	static void StartThreadL();
	static void RenameServer();
private:
	TInt 					iRefCount;
	CDelayServerShutDown* 	iDelayThreadServerShutDown;
	RDriver1 				iDriver;
	TDriverState			iDriverState;
	};
	


#endif
