// Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#ifndef __THREADCLIENT_H__
#define __THREADCLIENT_H__

#include <e32base.h>
#include <e32std.h>

/**
	Client interface for thread server
*/
class RThreadClient : public RSessionBase
	{
public:
	/**
	 Connects to the server, attempting to start it if necessary
	 */
	IMPORT_C TInt Connect();
	/**
	 Opens the device driver's logical channel
	 */
	IMPORT_C TInt OpenDriver();
	/**
	 Sends data to device (asynchronous request)
	 */
	IMPORT_C void Send(const TDesC8& aBuf, TRequestStatus& aStatus);
	/**
	 Cancels sending request
	 */
	IMPORT_C void SendCancel();
	/**
	 Unloads device driver
	 */
	IMPORT_C TInt UnloadDeviceDriver();
	/**
	 Loads device driver
	 */
	IMPORT_C TInt LoadDeviceDriver();
	};

#endif
