// Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Server shut down file 
//



/**
 @file
*/

#include "shutdownserver.h"

/**
	Wraps two phase construction.
*/
CDelayServerShutDown* CDelayServerShutDown::NewL()
	{
	CDelayServerShutDown* self = new(ELeave) CDelayServerShutDown;
	CleanupStack::PushL(self);
	self->ConstructL();
	CleanupStack::Pop();
	return self;
	}
/**
	Constructor
*/	
CDelayServerShutDown::CDelayServerShutDown()
: CActive(EPriorityStandard)
	{
	}

void CDelayServerShutDown::ConstructL()
	{
	User::LeaveIfError(iShutDownTimer.CreateLocal());
	CActiveScheduler::Add(this);
	}
/**
	Sets the time delay. 
	After this time interval if the number of connected clients stays at zero, the server will shut down.
*/	
void CDelayServerShutDown::SetDelay(TTimeIntervalMicroSeconds32 aDelay)
	{
	__ASSERT_ALWAYS(!IsActive(), User::Panic(_L("CDelayedShutDown"), 1));
	
	// Request another wait
	iShutDownTimer.After(iStatus, aDelay);
	SetActive();
	}
/**
	Destructor
*/	
CDelayServerShutDown::~CDelayServerShutDown()
	{
	Cancel();
	// Close timer
	iShutDownTimer.Close();
	}
/**
	Handles the active objects request completion event
*/
void CDelayServerShutDown::RunL()
	{
	// Stop the active scheduler
	CActiveScheduler::Stop();
	}
/**
	Cancels request	
*/	
void CDelayServerShutDown::DoCancel()
	{
	iShutDownTimer.Cancel();
	}


//EOF
