// Copyright (c) 1997-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#include "txtexamp.h"

#include <coemain.h>
#include <coeaui.h>

void CGraphicExampleControl::ConstructL(const TRect& aRect, MGraphicsExampleObserver* aFormObserver,
			const CCoeControl& aParent)
	{
	// remember observer
	iFormObserver=aFormObserver;
	// create window
	CreateWindowL(&aParent);
	// construct font for messages
  	TCoeFont font(TCoeFont::EMedium, TCoeFont::EPlain);
	CCoeControl::ScreenFont(font);
	// set rectangle to prescription
	SetRect(aRect);
	// go for it
	ActivateL();
	UpdateModelL(); // phase 0
	}

CGraphicExampleControl::~CGraphicExampleControl()
	{
	iCoeEnv->ReleaseScreenFont(iMessageFont);
	}

void CGraphicExampleControl::Quit()
	{
	iFormObserver->NotifyGraphicExampleFinished();
	}

void CGraphicExampleControl::NextPhaseL()
	{
	if (++iPhase >= iMaxPhases)
		Quit();
	else
		{
		UpdateModelL();
		if (!iUpdateModelDoesRedraw) DrawNow();
		}
	}

void CGraphicExampleControl::HandlePointerEventL(const TPointerEvent& aPointerEvent)
	{
	if (aPointerEvent.iType==TPointerEvent::EButton1Down) NextPhaseL();
	}

TKeyResponse CGraphicExampleControl::OfferKeyEventL(
			const TKeyEvent& aKeyEvent,TEventCode aType
			)
	{
	if (aType!=EEventKey) return EKeyWasNotConsumed;
	TInt code=aKeyEvent.iCode;
	switch (code)
		{
		case ' ':
			NextPhaseL();
			break;
		default:
			return EKeyWasNotConsumed;
		}
	return EKeyWasConsumed;
	}

