/*
 * ============================================================================
 *  Name     : CEComCalculatorAppView from EComCalculatorAppView.h
 *  Part of  : EComCalculator
 *  Created  : 17/11/2003 by Forum Nokia
 *  Version  : 1.0
 *  Copyright: Nokia Corporation
 * ============================================================================
 */

#ifndef __ECOMCALCULATORAPPVIEW_H__
#define __ECOMCALCULATORAPPVIEW_H__


#include <coecntrl.h>

class CEikLabel;
class CEikEdwin;

/**
 * Class:       CEComCalculatorAppView
 *
 * Description: An instance of this class is the Application View object for
 *              the EComCalculator example application.
 *              It shows two editboxes, where user can give in numbers.
 *              The view can also show the result, when some operation
 *              for the numbers has been performed.
 */
class CEComCalculatorAppView : public CCoeControl
    {

public:

    /**
     * Function: NewL
     *
     * Description: Create a CEComCalculatorAppView object, which will draw
     *              itself to aRect.
     *
     * Param:       aRect the rectangle this view will be drawn to
     *
     * Returns:     A pointer to the created instance of CEComCalculatorAppView
     */
    static CEComCalculatorAppView* NewL(const TRect& aRect);

    /**
     * Function:    ~CEComCalculatorAppView
     * Description: Destroy the object
     */
     ~CEComCalculatorAppView();

public:  // For the use of CEComCalculatorAppUi

    /**
     * Function:    GetA
     *
     * Description: Converts the text in iEdwinA to a TReal.
     *
     * Param:      aResult Result of conversion
     *
     * Returns:     KErrNone or one of the system-wide error codes.
     */
    TInt GetA(TReal &aResult) const;

    /**
     * Function:    GetB
     *
     * Description: Converts the text in iEdwinB to a TReal.
     *
     * Param:       aResult Result of conversion
     *
     * Returns:     KErrNone or one of the system-wide error codes.
     */
    TInt GetB(TReal &aResult) const;

    /**
     * Function:    ShowResult
     * Description: Shows the result of calculation operation. This
     *              will only update the iLabelResult according to
     *              given parameters. The format is
     *              aOperationName + ": " + aValue
     *
     * Param:       aOperationName String describing the operation
     *              which has been performed for the numbers A and B.
     *
     * Param:       aValue is the result of operation for A and B
     *
     * Returns:     KErrNone or one of the system-wide error codes.
     */
    void ShowResultL(const TDesC8& aOperationName, TReal aValue);

private: // Construction

    /**
     * Function:    ConstructL
     *
     * Description: Perform the second phase construction of a
     *              CEComCalculatorAppView object.
     *
     * Param:       aRect the rectangle this view will be drawn to
     */
    void ConstructL(const TRect& aRect);

    /**
     * Function:   CEComCalculatorAppView
     *
     * Description: Perform the first phase of two phase construction.
     */
    CEComCalculatorAppView();


private: // from CCoeControl

    /**
     * Function:    SizeChanged
     *
     * Description: Determines controls' sizes according to current state.
     */
    void SizeChanged();

    /**
     * Function:     CountComponentControls
     *
     * Returns:      Number of controls within this container.
     */
    TInt CountComponentControls() const;

    /**
     * Function:     ComponentControl
     *
     * Param:        aIndex of control
     *
     * Returns:      One of the controls this class owns.
     */
    CCoeControl* ComponentControl(TInt aIndex) const;

    /**
     * Function:     Draw
     *
     * Description:  Paints this container control (but not
     *               the controls within this container).
     *
     * Param:        aRect Frame rectangle for container.
     */
    void Draw(const TRect& aRect) const;

    /**
     * Function:     OfferKeyEventL
     *
     * Param:        aKeyEvent The key event.
     *
     * Param:        aType The type of the event.
     *
     * Returns:      Indicates whether or not the key event was
     *               used (consumed) by this control.
     */
    TKeyResponse OfferKeyEventL(const TKeyEvent& aKeyEvent,
                                TEventCode aType);

private:

    CEikLabel* iLabelA;      /** Label for text box A */
    CEikLabel* iLabelB;      /** Label for text box B */
    CEikEdwin* iEdwinA;      /** Text box to query number A */
    CEikEdwin* iEdwinB;      /** Text box to query number B */
    CEikLabel* iLabelResult; /** Result of calculation is shown here */
    };


#endif // __ECOMCALCULATORAPPVIEW_H__
