/*
 * ============================================================================
 *  Name     : CEComCalculatorApplication from EComCalculatorApplication.h
 *  Part of  : EComCalculator
 *  Created  : 17/11/2003 by Forum Nokia
 *  Version  : 1.0
 *  Copyright: Nokia Corporation
 * ============================================================================
 */

#ifndef __ECOMCALCULATORAPPLICATION_H__
#define __ECOMCALCULATORAPPLICATION_H__

#include <aknapp.h>

/**
 * Class:      CEComCalculatorApplication
 * Description:An instance of CEComCalculatorApplication is the application
 *             part of the AVKON application framework for the EComCalculator
 *             example application.
 *
 *             EComCalculator is an ECOM client application. It uses custom
 *             ECOM interface to access plugin implementations.
 *
 *             See EComCalculatorAppui.cpp how the custom interface is used.
 *             See the custom interface definition in ..\..\interface
 *             For more information on ECOM architecture, see the following
 *             section in S60 v2.0 SDK Help:
 *
 *                 Developer Library 
 *                     Symbian OS Guide 
 *                         C++ API guide 
 *                             Application Protocols 
 *                                 Using ECom
 *
 */
class CEComCalculatorApplication : public CAknApplication
    {
public: // from CAknApplication

    /**
     * Function:    AppDllUid
     * Description: Return the application DLL UID value
     * Returns:     The UID of this Application Dll
     */
    TUid AppDllUid() const;

protected: // from CAknApplication

    /**
     * Function:    CreateDocumentL
     * Description: Create a CApaDocument object and return a pointer to it.
     * Returns:     A pointer to the created document
     */
    CApaDocument* CreateDocumentL();

    };

#endif // __ECOMCALCULATORAPPLICATION_H__
