/*
 * ============================================================================
 *  Name     : CEComCalculatorAppUi from EComCalculatorAppui.h
 *  Part of  : EComCalculator
 *  Created  : 29/05/2006 by Forum Nokia
 *  Version  : 2.0
 *  Copyright: Nokia Corporation
 * ============================================================================
 */

#ifndef __ECOMCALCULATORAPPUI_H__
#define __ECOMCALCULATORAPPUI_H__

#include <aknappui.h>

class CEComCalculatorAppView;

/**
 * Class: CEComCalculatorAppUi
 *
 * Description: An instance of class CEComCalculatorAppUi is the UserInterface
 *              part of the AVKON application framework for the EComCalculator
 *              example application
 *
 *              This acts as ECOM client. The essential part is implementation
 *              of DoEComCalculationL method.
 */
class CEComCalculatorAppUi : public CAknAppUi
    {
public:

    /**
     * Function:    ConstructL
     *
     * Description: Perform the second phase construction of a
     *              CEComCalculatorAppUi object. this needs to be public due to
     *              the way the framework constructs the AppUi.
     */
    void ConstructL();

    /**
     * Function:    CEComCalculatorAppUi
     *
     * Description: Perform the first phase of two phase construction. This
     *              needs to be public due to the way the framework constructs
     *              the AppUi.
     */
    CEComCalculatorAppUi();


    /**
     * Function:    ~CEComCalculatorAppUi
     *
     * Description: Destroy the object
     */
    ~CEComCalculatorAppUi();



public: // from CAknAppUi

    /**
     * Function:    HandleCommandL
     *
     * Description: Handle user menu selections
     *
     * Param:       aCommand the enumerated code for the menu option selected
     */
    void HandleCommandL(TInt aCommand);

    /**
     * Function:    HandleResourceChangeL
     *
     * Description: Handles reource changes (scalable ui related)
     *
     * Param:       aType the type of the resource change
    */
    void HandleResourceChangeL(TInt aType);

private: // Helper functions

    /**
     * Function:    CalculateL
     *
     * Description: Gathers numbers from View and creates calculation operation
     *              name string according to given command. Does the
     *              calculation and shows the result in the view.
     *
     * Param:       aCommand the enumerated code for the menu option selected
     *              Is either ECalculateSumCmd or ECalculateMultiplyCmd.
     */
    void CalculateL(TInt aCommand);

    /**
     * Function:    DoEComCalculationL
     *
     * Description: Performs the calculation using ECOM plugin interface. If
     *              ECOM architecture does not find a plugin installed, or
     *              there is not a matching implementation for aOperationName,
     *              error is returned.
     *
     * Param:       aOperationName Name of calculation operation. This must
     *              match one of the provided plugin implementations. Valid
     *              values are defined in plugin resource file, see
     *              ..\..\plugin\101F5465.RSS
     *              for "default_data". Default resolver will use that value
     *              to find appropriate implementation.
     *
     * Param:       aA is one of the two numbers used for calculation
     *
     * Param:       aB is the other of the two numbers used for calculation.
     *
     * Param:       aResult will contain the result of calculation.
     *
     * Returns:     KErrNone, if successfull. Otherwise one of the ECOM
     *              internal implementation error codes like KErrNotFound.
     */
    TInt DoEComCalculationL(const TDesC8& aOperationName, TReal aA, TReal aB,
        TReal& aResult);

    /**
     * Function:    HandleEComInitializationErrorL
     *
     * Description: Handles errors during the ECOM plugin interface usage.
     *
     * Param:       aError Error code.
     *
     * Param:       aOperationName is name for the calculation operation. It is
     *              shown within info message.
     */
    void HandleEComInitializationErrorL(TInt aError,
        const TDesC8& aOperationName) const;

    /**
     * Function:    ShowNoteL
     *
     * Description: Shows simple text message dialog.
     *
     * Param:      aMessage message to be shown.
     */
    void ShowNoteL(const TDesC& aMessage) const;

private: // Members

    /** The application view */
    CEComCalculatorAppView* iAppView;

    };


#endif // __ECOMCALCULATORAPPUI_H__
