/*
 * ============================================================================
 *  Name     : CEComCalculatorDocument from EComCalculatorDocument.h
 *  Part of  : EComCalculator
 *  Created  : 17/11/2003 by Forum Nokia
 *  Version  : 1.0
 *  Copyright: Nokia Corporation
 * ============================================================================
 */

#ifndef __ECOMCALCULATORDOCUMENT_H__
#define __ECOMCALCULATORDOCUMENT_H__


#include <akndoc.h>

class CEComCalculatorAppUi;
class CEikApplication;


/**
 * Class:      CEComCalculatorDocument
 *
 * Discussion: An instance of class CEComCalculatorDocument is the Document
 *             part of the AVKON application framework for the ECom calculator
 *             example application.
 */
class CEComCalculatorDocument : public CAknDocument
    {
public:

    /**
     * Function:  NewL
     *
     * Discussion: Construct a CEComCalculatorDocument for the AVKON
     *             application aApp using two phase construction, and return
     *             a pointer to the created object.
     *
     * Param:      aApp application creating this document
     *
     * Returns:    A pointer to the created instance of CEComCalculatorDocument
     */
    static CEComCalculatorDocument* NewL(CEikApplication& aApp);

    /**
     * Function:   ~CEComCalculatorDocument
     *
     * Discussion: Destroy the object
     */
    ~CEComCalculatorDocument();

private: // Construction

    /**
     * Function:   ConstructL
     *
     * Discussion: Perform the second phase construction of a
     *             CEComCalculatorDocument object.
     */
    void ConstructL();

    /**
     * Function:   CEComCalculatorDocument
     *
     * Discussion: Perform the first phase of two phase construction
     *
     * Param:      aApp application creating this document
     */
    CEComCalculatorDocument(CEikApplication& aApp);

private: // From CAknDocument

    /**
     * Function:   CreateAppUiL
     *
     * Discussion: Create a CEComCalculatorDocument object and return a
     *             pointer to it.
     *
     * Returns:     A pointer to the created instance of the AppUi created
     */
    CEikAppUi* CreateAppUiL();

    };


#endif // __ECOMCALCULATORDOCUMENT_H__
