/*
 * ============================================================================
 *  Name     : CEComCalculatorAppView from EComCalculatorAppView.cpp
 *  Part of  : EComCalculator
 *  Created  : 17/11/2003 by Forum Nokia
 *  Version  : 1.0
 *  Copyright: Nokia Corporation
 * ============================================================================
 */


#include <barsread.h>  // for resource reader
#include <eiklabel.h>  // for label controls
#include <eikedwin.h>  // for CEikEdwin

#include "EComCalculatorAppView.h"
#include <EComCalculator.rsg> // Generated from EComCalculator.rss

// Constants used in controls' position calculations
const TInt KXPos = 10; //x position

// Constants
const TInt KNumberOfControls = 5; //Number of UI controls within this container
const TInt KBottomMargin = 10; //The amount of space to leave to bottom
const TInt KResultSize = 128;

// Constant texts
_LIT(KLabelTextA,"Number A:");
_LIT(KLabelTextB,"Number B:");
_LIT(KTextEmpty, "");

// Enumarations
enum TControls
    {
    ELabelA,
    EEdwinA,
    ELabelB,
    EEdwinB,
    ELabelResult
    };

// Create instance of this compound control.
CEComCalculatorAppView* CEComCalculatorAppView::NewL(const TRect& aRect)
    {
    CEComCalculatorAppView* self = new (ELeave) CEComCalculatorAppView;
    CleanupStack::PushL(self);
    self->ConstructL(aRect);
    CleanupStack::Pop(self);
    return self;
    }

// Perform the second phase construction. Instantiate the owned controls.
void CEComCalculatorAppView::ConstructL(const TRect& aRect)
    {

    // Create a window for this application view
    CreateWindowL();

    iLabelA = new (ELeave) CEikLabel;
    iLabelA->SetContainerWindowL(*this);
    iLabelA->SetTextL(KLabelTextA);

    iLabelB = new (ELeave) CEikLabel;
    iLabelB->SetContainerWindowL(*this);
    iLabelB->SetTextL(KLabelTextB);

    iLabelResult = new (ELeave) CEikLabel;
    iLabelResult->SetContainerWindowL(*this);
    iLabelResult->SetTextL(KTextEmpty);

    TResourceReader reader;
    iCoeEnv->CreateResourceReaderLC(reader, R_ECOMCALCULATOR_EDWIN);
    iEdwinA = new (ELeave) CEikEdwin;
    iEdwinA->SetContainerWindowL(*this);
    iEdwinA->ConstructFromResourceL(reader);
    CleanupStack::PopAndDestroy();  // Resource reader

    iCoeEnv->CreateResourceReaderLC(reader, R_ECOMCALCULATOR_EDWIN);
    iEdwinB = new (ELeave) CEikEdwin;
    iEdwinB->SetContainerWindowL(*this);
    iEdwinB->ConstructFromResourceL(reader);
    CleanupStack::PopAndDestroy();  // Resource reader

    SizeChanged();
    iEdwinA->SetFocus(ETrue);

    // Set the windows size
    SetRect(aRect);

    // Activate the window, which marks it ready to be drawn
    ActivateL();
    }

// Constructor.
CEComCalculatorAppView::CEComCalculatorAppView()
                        :iLabelA(NULL), iLabelB(NULL),
                         iEdwinA(NULL), iEdwinB(NULL),
                         iLabelResult(NULL)
    {
    // No implementation required
    }

// Destructor. Release the owned controls
CEComCalculatorAppView::~CEComCalculatorAppView()
    {
        delete iLabelA;
        delete iLabelB;
        delete iEdwinA;
        delete iEdwinB;
        delete iLabelResult;
    }

// Draw the view. Called by framework, when necessary.
void CEComCalculatorAppView::Draw(const TRect& aRect) const
    {
    //Clear the screen
    CWindowGc& gc = SystemGc();
    gc.Clear(Rect());
    gc.SetBrushColor(KRgbGray);
    gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
    gc.DrawRect(aRect);
    }

// Scale the owned controls to reflect current (new) state
void CEComCalculatorAppView::SizeChanged()
    {
    TRect rect = Rect();

    TInt bottom = rect.iBr.iY - KBottomMargin;
    TInt comp_height = bottom/KNumberOfControls;

    TPoint label_a_pos = TPoint(KXPos, bottom- comp_height*5);
    TPoint edwin_a_pos  =    TPoint(KXPos, bottom- comp_height*4);
    TPoint label_b_pos = TPoint(KXPos, bottom- comp_height*3);
    TPoint edwin_b_pos  =    TPoint(KXPos, bottom- comp_height*2);
    TPoint label_result_pos = TPoint(KXPos, bottom - comp_height);

    iLabelA->SetExtent(label_a_pos, iLabelA->MinimumSize());
    iLabelB->SetExtent(label_b_pos, iLabelB->MinimumSize());
    iEdwinA->SetExtent(edwin_a_pos, iEdwinA->MinimumSize());
    iEdwinB->SetExtent(edwin_b_pos, iEdwinB->MinimumSize());
    
    //Adjust the extent so it doesn't cut off y and p 
    //in "multiply", test with out this to see it
    TSize extent = iLabelResult->MinimumSize();
    extent.iHeight += KBottomMargin;
    
    iLabelResult->SetExtent(label_result_pos,
        //this cuts off the bottom of y and p in "multiply"
        //iLabelResult->MinimumSize()); 
        extent );
    }

// Tell the framework the number of owned controls
TInt CEComCalculatorAppView::CountComponentControls() const
    {
    return KNumberOfControls;
    }

// Return owned control to framework so it will draw it.
CCoeControl* CEComCalculatorAppView::ComponentControl(TInt aIndex) const
    {
    switch (aIndex)
        {
        case ELabelA:       // 0
            return iLabelA;
        case EEdwinA:       // 1
            return iEdwinA;
        case ELabelB:       // 2
            return iLabelB;
        case EEdwinB:       // 3
            return iEdwinB;
        case ELabelResult:  // 4
            return iLabelResult;
        default:
            return NULL;
        }
    }

// Handle key events. User of this view control must add this to control
// stack to ensure this component is able to get key events. In practise
// see how it is done in AppUI: CEComCalculatorAppUi::ConstructL()
TKeyResponse CEComCalculatorAppView::OfferKeyEventL(const TKeyEvent& aKeyEvent,
                            TEventCode aType)
    {

    // Handle key up & down. Switch edit boxes, if appropriate
    switch (aKeyEvent.iScanCode)
        {
        case EStdKeyUpArrow:
            if(iEdwinB && iEdwinB->IsFocused())
            {
                iEdwinB->SetFocus(EFalse);
                iEdwinA->SetFocus(ETrue);
                return EKeyWasConsumed;
            }
            break;

        case EStdKeyDownArrow:
            if(iEdwinA && iEdwinA->IsFocused())
            {
                iEdwinA->SetFocus(EFalse);
                iEdwinB->SetFocus(ETrue);
                return EKeyWasConsumed;
            }
            break;
        }

    // Let the focused edit box handle the key event
    if (iEdwinA && iEdwinA->IsFocused())
        {
        return iEdwinA->OfferKeyEventL(aKeyEvent, aType);
        }
    if (iEdwinB && iEdwinB->IsFocused())
        {
        return iEdwinB->OfferKeyEventL(aKeyEvent, aType);
        }

    return EKeyWasNotConsumed;
    }


// Convert text in the edit box to a number.
TInt CEComCalculatorAppView::GetA(TReal &aResult) const
    {
        TInt err = KErrGeneral;
        if(iEdwinA)
        {
            TLex16 lex(iEdwinA->Text()->Read(0));
            err = lex.Val(aResult);
        }
        return err;
    }

// Convert text in the edit box to a number.
TInt CEComCalculatorAppView::GetB(TReal &aResult) const
    {
        TInt err = KErrGeneral;
        if(iEdwinB)
        {
            TLex16 lex(iEdwinB->Text()->Read(0));
            err = lex.Val(aResult);
        }
        return err;
    }

// Update text in iLabelResult. Show result of calculation
void CEComCalculatorAppView::ShowResultL(const TDesC8& aOperationName,
    TReal aValue)
    {
    TRealFormat format;
    TBuf<KResultSize> resultStr;
    _LIT(KSeparator,": ");
    resultStr.Copy(aOperationName);
    resultStr.Append(KSeparator);
    resultStr.AppendNum(aValue,format);
    iLabelResult->SetTextL(resultStr);
    SizeChanged();
    DrawDeferred();
    }
